/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.qcloud;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.store.qcloud.QCloudVectorStoreConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class QCloudVectorStore
extends DocumentStore {
    private QCloudVectorStoreConfig config;
    private final HttpClient httpUtil = new HttpClient();

    public QCloudVectorStore(QCloudVectorStoreConfig config) {
        this.config = config;
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer account=" + this.config.getAccount() + "&api_key=" + this.config.getApiKey());
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("database", this.config.getDatabase());
        payloadMap.put("collection", options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()));
        ArrayList payloadDocs = new ArrayList();
        for (Document vectorDocument : documents) {
            HashMap<String, Object> document = new HashMap<String, Object>();
            if (vectorDocument.getMetadataMap() != null) {
                document.putAll(vectorDocument.getMetadataMap());
            }
            document.put("vector", vectorDocument.getVector());
            document.put("id", vectorDocument.getId());
            payloadDocs.add(document);
        }
        payloadMap.put("documents", payloadDocs);
        String payload = JSON.toJSONString(payloadMap);
        this.httpUtil.post(this.config.getHost() + "/document/upsert", headers, payload);
        return StoreResult.successWithIds(documents);
    }

    public StoreResult deleteInternal(Collection<Object> ids, StoreOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer account=" + this.config.getAccount() + "&api_key=" + this.config.getApiKey());
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("database", this.config.getDatabase());
        payloadMap.put("collection", options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()));
        HashMap<String, Collection<Object>> documentIdsObj = new HashMap<String, Collection<Object>>();
        documentIdsObj.put("documentIds", ids);
        payloadMap.put("query", documentIdsObj);
        String payload = JSON.toJSONString(payloadMap);
        this.httpUtil.post(this.config.getHost() + "/document/delete", headers, payload);
        return StoreResult.success();
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer account=" + this.config.getAccount() + "&api_key=" + this.config.getApiKey());
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("database", this.config.getDatabase());
        payloadMap.put("collection", options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()));
        for (Document document : documents) {
            HashMap<String, List<Object>> documentIdsObj = new HashMap<String, List<Object>>();
            documentIdsObj.put("documentIds", Collections.singletonList(document.getId()));
            payloadMap.put("query", documentIdsObj);
            payloadMap.put("update", document.getMetadataMap());
            String payload = JSON.toJSONString(payloadMap);
            this.httpUtil.post(this.config.getHost() + "/document/update", headers, payload);
        }
        return StoreResult.successWithIds(documents);
    }

    public List<Document> searchInternal(SearchWrapper searchWrapper, StoreOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer account=" + this.config.getAccount() + "&api_key=" + this.config.getApiKey());
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("database", this.config.getDatabase());
        payloadMap.put("collection", options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()));
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        searchMap.put("vectors", Collections.singletonList(searchWrapper.getVector()));
        if (searchWrapper.getMaxResults() != null) {
            searchMap.put("limit", searchWrapper.getMaxResults());
        }
        payloadMap.put("search", searchMap);
        String payload = JSON.toJSONString(payloadMap);
        String response = this.httpUtil.post(this.config.getHost() + "/document/search", headers, payload);
        if (StringUtil.noText((String)response)) {
            return null;
        }
        ArrayList<Document> result = new ArrayList<Document>();
        JSONObject rootObject = JSON.parseObject((String)response);
        int code = rootObject.getIntValue("code");
        if (code != 0) {
            LoggerFactory.getLogger(QCloudVectorStore.class).error("can not search in QCloudVectorStore, code:" + code + ",  message: " + rootObject.getString("msg"));
            return null;
        }
        JSONArray rootDocs = rootObject.getJSONArray("documents");
        for (int i = 0; i < rootDocs.size(); ++i) {
            JSONArray docs = rootDocs.getJSONArray(i);
            for (int j = 0; j < docs.size(); ++j) {
                JSONObject doc = docs.getJSONObject(j);
                Document vd = new Document();
                vd.setId((Object)doc.getString("id"));
                doc.remove((Object)"id");
                vd.addMetadata((Map)doc);
                result.add(vd);
            }
        }
        return result;
    }
}

