/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.common.toolkit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ObjectUtils {
    public static boolean isNull(Object ... objs) {
        for (Object obj : objs) {
            if (!ObjectUtils.isEmpty(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotNull(Object ... obj) {
        return !ObjectUtils.isNull(obj);
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectUtils.isEmpty(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return !((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public static byte[] toByteArray(Object obj) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(obj);
        return outputStream.toByteArray();
    }

    public static <T> T readObject(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        ObjectInputStream oInputStream = new ObjectInputStream(inputStream);
        return (T)oInputStream.readObject();
    }
}

