/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.common.toolkit;

import com.aizuda.common.toolkit.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtils {
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String LOCAL_ADDRESS = "0:0:0:0:0:0:0:1";
    private static final String[] HEADERS = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR", "X-Real-IP"};

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getIp(HttpServletRequest request) {
        String ip = null;
        for (String header : HEADERS) {
            String currentIp = request.getHeader(header);
            if (!RequestUtils.isNotUnknown(currentIp)) continue;
            ip = currentIp;
            break;
        }
        if (null == ip) {
            ip = request.getRemoteAddr();
        }
        if (null == ip) {
            return "";
        }
        if (LOCAL_ADDRESS.equals(ip)) {
            return LOCAL_IP;
        }
        return RequestUtils.getMultistageReverseProxyIp(ip);
    }

    private static String getMultistageReverseProxyIp(String ip) {
        String delimiter = ",";
        if (ip != null && ip.indexOf(delimiter) > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(delimiter)) {
                if (!RequestUtils.isNotUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    private static boolean isNotUnknown(String checkIp) {
        return StringUtils.hasLength(checkIp) && !"unknown".equalsIgnoreCase(checkIp);
    }
}

