/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.bpm.spring.adaptive;

import com.aizuda.bpm.engine.FlowLongExpression;
import com.aizuda.bpm.engine.model.NodeExpression;
import java.util.List;
import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelFlowLongExpression
implements FlowLongExpression {
    private final ExpressionParser parser = new SpelExpressionParser();

    public boolean eval(List<List<NodeExpression>> conditionList, Map<String, Object> args) {
        return this.eval(conditionList, () -> args, expr -> {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariables(args);
            return (Boolean)this.parser.parseExpression(expr).getValue((EvaluationContext)context, Boolean.class);
        });
    }

    public String exprOfArgs(NodeExpression nodeExpression, Map<String, Object> args) {
        String value = nodeExpression.getValue();
        String operator = nodeExpression.getOperator();
        String field = nodeExpression.getField();
        if ("include".equalsIgnoreCase(operator)) {
            return "#" + field + ".contains('" + value + "')";
        }
        if ("notinclude".equalsIgnoreCase(operator)) {
            return "not #" + field + ".contains('" + value + "')";
        }
        Object fieldValue = args.get(nodeExpression.getField());
        if (fieldValue instanceof String) {
            value = "'" + value + "'";
        }
        return "#" + field + " " + operator + " " + value;
    }
}

