/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.core.dto.RetryDTO;
import com.aizuda.snailjob.client.core.handler.AbstractRetryRequestHandler;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import java.util.Objects;

public class QueryRetryHandler
extends AbstractRetryRequestHandler<RetryDTO> {
    private final Long retryId;

    public QueryRetryHandler(Long retryId) {
        this.retryId = retryId;
    }

    protected RetryDTO doExecute() {
        Result<Object> result = this.client.queryRetryTask(this.retryId);
        Assert.isTrue((StatusEnum.YES.getStatus().intValue() == result.getStatus() ? 1 : 0) != 0, () -> new SnailJobClientException(result.getMessage()));
        Object data = result.getData();
        Assert.isTrue((boolean)Objects.nonNull(data), () -> new SnailJobClientException("Failed to get details of task [{}]", (Object)this.retryId));
        return (RetryDTO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)data), RetryDTO.class);
    }

    protected Pair<Boolean, String> checkRequest() {
        return Pair.of((Object)(this.retryId != null && this.retryId > 0L ? 1 : 0), (Object)"retryId cannot be null and must be greater than 0");
    }
}

