/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.intercepter;

import com.aizuda.snailjob.client.core.RetrySiteSnapshotContext;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.loader.SnailRetrySpiLoader;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingDeque;
import lombok.Generated;

public class RetrySiteSnapshot {
    private static final String RETRY_STAGE_KEY = "RETRY_STAGE";
    private static final String RETRY_CLASS_METHOD_ENTRANCE_KEY = "RETRY_CLASS_METHOD_ENTRANCE";
    private static final String RETRY_STATUS_KEY = "RETRY_STATUS";
    private static final RetrySiteSnapshotContext<Integer> RETRY_STAGE = SnailRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<Deque<MethodEntranceMeta>> RETRY_CLASS_METHOD_ENTRANCE = SnailRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<Integer> RETRY_STATUS = SnailRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<SnailJobHeaders> RETRY_HEADER = SnailRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<String> RETRY_STATUS_CODE = SnailRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<Map<String, Object>> SUSPEND = SnailRetrySpiLoader.loadRetrySiteSnapshotContext();
    private static final RetrySiteSnapshotContext<Long> ENTRY_METHOD_TIME = SnailRetrySpiLoader.loadRetrySiteSnapshotContext();

    public static void suspend() {
        SUSPEND.set((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(RetrySiteSnapshot.RETRY_STAGE_KEY, RETRY_STAGE.get());
                this.put(RetrySiteSnapshot.RETRY_STATUS_KEY, RETRY_STATUS.get());
                this.put(RetrySiteSnapshot.RETRY_CLASS_METHOD_ENTRANCE_KEY, RETRY_CLASS_METHOD_ENTRANCE.get());
            }
        });
    }

    public static void restore() {
        Optional.ofNullable(SUSPEND.get()).ifPresent(map -> {
            RETRY_STAGE.set((Integer)map.get(RETRY_STAGE_KEY));
            RETRY_STATUS.set((Integer)map.get(RETRY_STATUS_KEY));
            RETRY_CLASS_METHOD_ENTRANCE.set((Deque)map.get(RETRY_CLASS_METHOD_ENTRANCE_KEY));
            SUSPEND.remove();
        });
    }

    public static Integer getStage() {
        return RETRY_STAGE.get();
    }

    public static void setStage(int stage) {
        RETRY_STAGE.set(stage);
    }

    public static String getMethodEntrance() {
        Deque<MethodEntranceMeta> stack = RETRY_CLASS_METHOD_ENTRANCE.get();
        if (Objects.isNull(stack) || Objects.isNull(stack.peek())) {
            return null;
        }
        return stack.peek().methodEntrance;
    }

    public static boolean existedMethodEntrance() {
        Deque<MethodEntranceMeta> stack = RETRY_CLASS_METHOD_ENTRANCE.get();
        if (Objects.isNull(stack)) {
            return Boolean.FALSE;
        }
        MethodEntranceMeta meta = stack.peek();
        if (Objects.isNull(meta)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static void setMethodEntrance(String methodEntrance) {
        Deque<MethodEntranceMeta> stack = RETRY_CLASS_METHOD_ENTRANCE.get();
        if (Objects.isNull(RETRY_CLASS_METHOD_ENTRANCE.get())) {
            stack = new LinkedBlockingDeque<MethodEntranceMeta>();
            RETRY_CLASS_METHOD_ENTRANCE.set(stack);
        }
        if (!RetrySiteSnapshot.isRunning() && !RetrySiteSnapshot.isRetryFlow()) {
            MethodEntranceMeta meta = new MethodEntranceMeta(methodEntrance);
            stack.push(meta);
        }
    }

    public static void removeMethodEntrance() {
        Deque<MethodEntranceMeta> stack = RETRY_CLASS_METHOD_ENTRANCE.get();
        if (Objects.isNull(stack)) {
            return;
        }
        if (stack.isEmpty()) {
            RETRY_CLASS_METHOD_ENTRANCE.remove();
            return;
        }
        if (!RetrySiteSnapshot.isRunning() && !RetrySiteSnapshot.isRetryFlow()) {
            stack.pop();
        }
    }

    public static boolean isMethodEntrance(String methodEntrance) {
        Deque<MethodEntranceMeta> stack = RETRY_CLASS_METHOD_ENTRANCE.get();
        if (Objects.isNull(stack) || Objects.isNull(stack.peek())) {
            return Boolean.FALSE;
        }
        MethodEntranceMeta peek = stack.peek();
        return methodEntrance.equals(peek.methodEntrance);
    }

    public static Integer getStatus() {
        return Optional.ofNullable(RETRY_STATUS.get()).orElse(EnumStatus.COMPLETE.status);
    }

    public static void setStatus(Integer status) {
        RETRY_STATUS.set(status);
    }

    public static boolean isRunning() {
        return EnumStatus.RUNNING.status == RetrySiteSnapshot.getStatus();
    }

    public static SnailJobHeaders getRetryHeader() {
        return RETRY_HEADER.get();
    }

    public static void setRetryHeader(SnailJobHeaders headers) {
        RETRY_HEADER.set(headers);
    }

    public static boolean isRetryFlow() {
        SnailJobHeaders retryHeader = RetrySiteSnapshot.getRetryHeader();
        if (Objects.nonNull(retryHeader)) {
            return retryHeader.isRetry();
        }
        return false;
    }

    public static String getRetryStatusCode() {
        return RETRY_STATUS_CODE.get();
    }

    public static void setRetryStatusCode(String statusCode) {
        RETRY_STATUS_CODE.set(statusCode);
    }

    public static boolean isRetryForStatusCode() {
        return Objects.nonNull(RetrySiteSnapshot.getRetryStatusCode()) && RetrySiteSnapshot.getRetryStatusCode().equals("519");
    }

    public static Long getEntryMethodTime() {
        return ENTRY_METHOD_TIME.get();
    }

    public static void setEntryMethodTime(long entryMethodTime) {
        ENTRY_METHOD_TIME.set(entryMethodTime);
    }

    public static void removeEntryMethodTime() {
        ENTRY_METHOD_TIME.remove();
    }

    public static void removeRetryHeader() {
        RETRY_HEADER.remove();
    }

    public static void removeRetryStatusCode() {
        RETRY_STATUS_CODE.remove();
    }

    public static void removeStage() {
        RETRY_STAGE.remove();
    }

    public static void removeStatus() {
        RETRY_STATUS.remove();
    }

    public static void removeAll() {
        RetrySiteSnapshot.removeStatus();
        RetrySiteSnapshot.removeStage();
        RetrySiteSnapshot.removeEntryMethodTime();
        RetrySiteSnapshot.removeRetryHeader();
        RetrySiteSnapshot.removeRetryStatusCode();
        RetrySiteSnapshot.removeMethodEntrance();
    }

    public static class MethodEntranceMeta {
        private String methodEntrance;

        @Generated
        public String getMethodEntrance() {
            return this.methodEntrance;
        }

        @Generated
        public MethodEntranceMeta(String methodEntrance) {
            this.methodEntrance = methodEntrance;
        }
    }

    public static enum EnumStatus {
        RUNNING(1),
        COMPLETE(2);

        private final int status;

        private EnumStatus(int status) {
            this.status = status;
        }

        @Generated
        public int getStatus() {
            return this.status;
        }
    }

    public static enum EnumStage {
        LOCAL(1),
        REMOTE(2),
        MANUAL_REPORT(3);

        private final int stage;

        private EnumStage(int stage) {
            this.stage = stage;
        }

        public static EnumStage valueOfStage(int stage) {
            for (EnumStage value : EnumStage.values()) {
                if (value.getStage() != stage) continue;
                return value;
            }
            throw new SnailRetryClientException("unsupported stage");
        }

        @Generated
        public int getStage() {
            return this.stage;
        }
    }
}

