/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.serializer;

import com.aizuda.snailjob.client.core.RetryArgSerializer;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer
implements RetryArgSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);

    @Override
    public String serialize(Object serializeInfo) {
        return JsonUtil.toJsonString((Object)serializeInfo);
    }

    @Override
    public Object deSerialize(String infoStr, Class tClass, Method method) throws JsonProcessingException {
        Type[] paramTypes = method.getGenericParameterTypes();
        Object[] params = new Object[paramTypes.length];
        ObjectMapper mapper = JsonUtil.JsonMapper.jacksonObjectMapper();
        JsonNode jsonNode = JsonUtil.toJson((String)infoStr);
        if (Objects.isNull(jsonNode)) {
            SnailJobLog.LOCAL.warn("jsonNode is null. infoStr:[{}]", new Object[]{infoStr});
            return params;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            JsonNode node = jsonNode.get(i);
            if (!Objects.nonNull(node)) continue;
            params[i] = mapper.readValue(node.toString(), mapper.constructType(paramTypes[i]));
        }
        return params;
    }
}

