/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryPartitionTask;
import com.aizuda.snailjob.server.retry.task.service.RetryDeadLetterConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailDeadLetterAlarmEvent;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Component
public class CleanerSchedule
extends AbstractSchedule
implements Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CleanerSchedule.class);
    private final RetryMapper retryMapper;
    private final RetryTaskMapper retryTaskMapper;
    private final SystemProperties systemProperties;
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;
    private final TransactionTemplate transactionTemplate;
    private final AccessTemplate accessTemplate;

    public String lockName() {
        return "clearLog";
    }

    public String lockAtMost() {
        return "PT4H";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    protected void doExecute() {
        try {
            if (this.systemProperties.getLogStorage() < 1) {
                SnailJobLog.LOCAL.error("retry clear log storage error", new Object[]{this.systemProperties.getLogStorage()});
                return;
            }
            LocalDateTime endTime = LocalDateTime.now().minusDays(this.systemProperties.getLogStorage());
            long total = PartitionTaskUtils.process(startId -> this.retryTaskBatchList(startId, endTime), this::processRetryLogPartitionTasks, (long)0L);
            SnailJobLog.LOCAL.debug("Retry clear success total:[{}]", new Object[]{total});
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("clear log error", new Object[]{e});
        }
    }

    private List<RetryPartitionTask> retryTaskBatchList(Long startId, LocalDateTime endTime) {
        List retryTaskList = ((Page)this.retryMapper.selectPage((IPage)new Page(0L, 500L, Boolean.FALSE.booleanValue()), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ge(Retry::getId, (Object)startId)).le(CreateDt::getCreateDt, (Object)endTime)).eq(Retry::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).ne(Retry::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByAsc(Retry::getId))).getRecords();
        return RetryTaskConverter.INSTANCE.toRetryTaskLogPartitionTasks(retryTaskList);
    }

    public void processRetryLogPartitionTasks(List<? extends PartitionTask> partitionTasks) {
        List retryIds = StreamUtils.toList(partitionTasks, PartitionTask::getId);
        if (CollectionUtils.isEmpty((Collection)retryIds)) {
            return;
        }
        List cbRetries = this.retryMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Retry::getId}).in(Retry::getParentId, (Collection)retryIds));
        ArrayList totalWaitRetryIds = Lists.newArrayList((Iterable)retryIds);
        List cbRetryIds = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)cbRetries)) {
            cbRetryIds = StreamUtils.toList((Collection)cbRetries, Retry::getId);
            totalWaitRetryIds.addAll(cbRetryIds);
        }
        List<? extends PartitionTask> retryPartitionTasks = partitionTasks;
        final List<Long> finishRetryIds = retryPartitionTasks.stream().filter(retryPartitionTask -> RetryStatusEnum.FINISH.getStatus().equals(retryPartitionTask.getRetryStatus())).map(PartitionTask::getId).toList();
        final List retryTaskList = this.retryTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().in(RetryTask::getRetryId, (Collection)totalWaitRetryIds));
        final List retryTaskLogMessageList = this.retryTaskLogMessageMapper.selectList((Wrapper)new LambdaQueryWrapper().in(RetryTaskLogMessage::getRetryId, (Collection)totalWaitRetryIds));
        final List finalCbRetryIds = cbRetryIds;
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                CleanerSchedule.this.retryMapper.deleteByIds((Collection)finalCbRetryIds);
                CleanerSchedule.this.retryMapper.deleteByIds((Collection)finishRetryIds);
                if (!CollectionUtils.isEmpty((Collection)retryTaskList)) {
                    List retryTaskIds = StreamUtils.toList((Collection)retryTaskList, RetryTask::getId);
                    Lists.partition((List)retryTaskIds, (int)500).forEach(arg_0 -> ((RetryTaskMapper)CleanerSchedule.this.retryTaskMapper).deleteByIds(arg_0));
                }
                if (!CollectionUtils.isEmpty((Collection)retryTaskLogMessageList)) {
                    List retryTaskLogMessageIds = StreamUtils.toList((Collection)retryTaskLogMessageList, RetryTaskLogMessage::getId);
                    Lists.partition((List)retryTaskLogMessageIds, (int)500).forEach(arg_0 -> ((RetryTaskLogMessageMapper)CleanerSchedule.this.retryTaskLogMessageMapper).deleteByIds(arg_0));
                }
            }
        });
        List<RetryPartitionTask> maxCountRetries = retryPartitionTasks.stream().filter(retryPartitionTask -> RetryStatusEnum.MAX_COUNT.getStatus().equals(retryPartitionTask.getRetryStatus())).toList();
        this.moveDeadLetters(maxCountRetries);
    }

    private void moveDeadLetters(List<RetryPartitionTask> retries) {
        if (CollUtil.isEmpty(retries)) {
            return;
        }
        List<RetryDeadLetter> retryDeadLetters = RetryDeadLetterConverter.INSTANCE.toRetryDeadLetter(retries);
        LocalDateTime now = LocalDateTime.now();
        for (RetryDeadLetter retryDeadLetter : retryDeadLetters) {
            retryDeadLetter.setCreateDt(now);
        }
        Assert.isTrue((retryDeadLetters.size() == this.accessTemplate.getRetryDeadLetterAccess().insertBatch(retryDeadLetters) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to insert into dead letter queue [{}]", new Object[]{JsonUtil.toJsonString((Object)retryDeadLetters)}));
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryAccess();
        Assert.isTrue((retries.size() == retryTaskAccess.delete((LambdaQueryWrapper)new LambdaQueryWrapper().in(Retry::getId, (Collection)StreamUtils.toList(retries, PartitionTask::getId))) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete retry data [{}]", new Object[]{JsonUtil.toJsonString((Object)retries)}));
        SnailSpringContext.getContext().publishEvent((ApplicationEvent)new RetryTaskFailDeadLetterAlarmEvent(RetryTaskConverter.INSTANCE.toRetryTaskFailDeadLetterAlarmEventDTO(retryDeadLetters)));
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((CleanerSchedule)this).execute(), Duration.parse("PT4H"));
    }

    public void close() {
    }

    @Generated
    public CleanerSchedule(RetryMapper retryMapper, RetryTaskMapper retryTaskMapper, SystemProperties systemProperties, RetryTaskLogMessageMapper retryTaskLogMessageMapper, TransactionTemplate transactionTemplate, AccessTemplate accessTemplate) {
        this.retryMapper = retryMapper;
        this.retryTaskMapper = retryTaskMapper;
        this.systemProperties = systemProperties;
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
        this.transactionTemplate = transactionTemplate;
        this.accessTemplate = accessTemplate;
    }
}

