/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.context.nacos;

import com.alibaba.alicloud.context.listener.AbstractOnceApplicationListener;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfigurationFactory;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;

public class NacosDiscoveryParameterInitListener
extends AbstractOnceApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryParameterInitListener.class);

    @Override
    protected String conditionalOnClass() {
        return "com.alibaba.cloud.nacos.NacosDiscoveryAutoConfiguration";
    }

    @Override
    protected void handleEvent(ApplicationEnvironmentPreparedEvent event) {
        EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory.getEdasChangeOrderConfiguration();
        if (log.isDebugEnabled()) {
            log.debug("Initialize Nacos Discovery Parameter ,is managed {}.", (Object)edasChangeOrderConfiguration.isEdasManaged());
        }
        if (!edasChangeOrderConfiguration.isEdasManaged()) {
            return;
        }
        Properties properties = System.getProperties();
        properties.setProperty("spring.cloud.nacos.discovery.server-mode", "EDAS");
        properties.setProperty("spring.cloud.nacos.discovery.server-addr", "");
        properties.setProperty("spring.cloud.nacos.discovery.endpoint", edasChangeOrderConfiguration.getAddressServerDomain());
        properties.setProperty("spring.cloud.nacos.discovery.namespace", edasChangeOrderConfiguration.getTenantId());
        properties.setProperty("spring.cloud.nacos.discovery.access-key", edasChangeOrderConfiguration.getDauthAccessKey());
        properties.setProperty("spring.cloud.nacos.discovery.secret-key", edasChangeOrderConfiguration.getDauthSecretKey());
        properties.setProperty("nacos.naming.web.context", "/vipserver");
        properties.setProperty("nacos.naming.exposed.port", "80");
    }
}

