/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.scx.endpoint;

import com.alibaba.alicloud.context.edas.EdasProperties;
import com.alibaba.alicloud.context.scx.ScxProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="scx")
public class ScxEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScxEndpoint.class);
    private ScxProperties scxProperties;
    private EdasProperties edasProperties;

    public ScxEndpoint(EdasProperties edasProperties, ScxProperties scxProperties) {
        this.edasProperties = edasProperties;
        this.scxProperties = scxProperties;
    }

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> scxEndpoint = new HashMap<String, Object>();
        LOGGER.info("SCX endpoint invoke, scxProperties is {}", (Object)this.scxProperties);
        scxEndpoint.put("namespace", this.edasProperties == null ? "" : this.edasProperties.getNamespace());
        scxEndpoint.put("scxProperties", this.scxProperties);
        return scxEndpoint;
    }
}

