/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel;

import com.alibaba.cloud.circuitbreaker.sentinel.SentinelCircuitBreakerFactory;
import com.alibaba.csp.sentinel.SphU;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SphU.class})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.sentinel.enabled"}, havingValue="true", matchIfMissing=true)
public class SentinelCircuitBreakerAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<SentinelCircuitBreakerFactory>> customizers = new ArrayList<Customizer<SentinelCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public CircuitBreakerFactory sentinelCircuitBreakerFactory() {
        SentinelCircuitBreakerFactory factory = new SentinelCircuitBreakerFactory();
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }
}

