/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel.feign;

import com.alibaba.cloud.circuitbreaker.sentinel.ReactiveSentinelCircuitBreakerFactory;
import com.alibaba.cloud.circuitbreaker.sentinel.SentinelCircuitBreakerFactory;
import com.alibaba.cloud.circuitbreaker.sentinel.feign.CircuitBreakerRuleChangeListener;
import com.alibaba.cloud.circuitbreaker.sentinel.feign.FeignClientCircuitNameResolver;
import com.alibaba.cloud.circuitbreaker.sentinel.feign.SentinelFeignClientProperties;
import feign.Feign;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.circuitbreaker.AbstractCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.openfeign.CircuitBreakerNameResolver;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Feign.class, FeignClientFactoryBean.class})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.sentinel.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelFeignClientProperties.class})
public class SentinelFeignClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"})
    public static class ReactiveSentinelCustomizerConfiguration {
        @Bean
        public Customizer<ReactiveSentinelCircuitBreakerFactory> reactiveConfigureRulesCustomizer(SentinelFeignClientProperties properties) {
            return factory -> {
                CircuitBreakerRuleChangeListener.configureDefault(properties, (AbstractCircuitBreakerFactory)factory);
                CircuitBreakerRuleChangeListener.configureCustom(properties, (AbstractCircuitBreakerFactory)factory);
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class SentinelCustomizerConfiguration {
        @Bean
        public Customizer<SentinelCircuitBreakerFactory> configureRulesCustomizer(SentinelFeignClientProperties properties) {
            return factory -> {
                CircuitBreakerRuleChangeListener.configureDefault(properties, (AbstractCircuitBreakerFactory)factory);
                CircuitBreakerRuleChangeListener.configureCustom(properties, (AbstractCircuitBreakerFactory)factory);
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CircuitBreakerNameResolver.class})
    public static class CircuitBreakerNameResolverConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={CircuitBreakerNameResolver.class})
        public CircuitBreakerNameResolver feignClientCircuitNameResolver(ObjectProvider<List<AbstractCircuitBreakerFactory>> provider) {
            List factories = (List)provider.getIfAvailable(Collections::emptyList);
            if (factories.size() >= 1) {
                return new FeignClientCircuitNameResolver((AbstractCircuitBreakerFactory)factories.get(0));
            }
            throw new IllegalArgumentException("need one CircuitBreakerFactory/ReactiveCircuitBreakerFactory, but 0 found.");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"feign.sentinel.refresh-rules"}, havingValue="true", matchIfMissing=true)
    public static class CircuitBreakerListenerConfiguration {
        @Bean
        public CircuitBreakerRuleChangeListener circuitBreakerRuleChangeListener() {
            return new CircuitBreakerRuleChangeListener();
        }
    }
}

