/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.support;

import com.alibaba.cloud.stream.binder.rocketmq.convert.RocketMQMessageConverter;
import com.alibaba.cloud.stream.binder.rocketmq.custom.RocketMQBeanContainerCache;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ObjectUtils;

public final class RocketMQMessageConverterSupport {
    private static final CompositeMessageConverter MESSAGE_CONVERTER = RocketMQBeanContainerCache.getBean("com.alibaba.cloud.stream.binder.rocketmq.convert.RocketMQMessageConverter", CompositeMessageConverter.class, new RocketMQMessageConverter().getMessageConverter());

    private RocketMQMessageConverterSupport() {
    }

    public static org.springframework.messaging.Message convertMessage2Spring(MessageExt message) {
        MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)message.getBody()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("KEYS"), (Object)message.getKeys()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("TAGS"), (Object)message.getTags()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_TOPIC"), (Object)message.getTopic()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_MESSAGE_ID"), (Object)message.getMsgId()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_BORN_TIMESTAMP"), (Object)message.getBornTimestamp()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_BORN_HOST"), (Object)message.getBornHostString()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_FLAG"), (Object)message.getFlag()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_QUEUE_ID"), (Object)message.getQueueId()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_SYS_FLAG"), (Object)message.getSysFlag()).setHeader(RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_TRANSACTION_ID"), (Object)message.getTransactionId());
        RocketMQMessageConverterSupport.addUserProperties(message.getProperties(), messageBuilder);
        return messageBuilder.build();
    }

    public static String toRocketHeaderKey(String rawKey) {
        return "ROCKET_" + rawKey;
    }

    private static void addUserProperties(Map<String, String> properties, MessageBuilder messageBuilder) {
        if (!CollectionUtils.isEmpty(properties)) {
            properties.forEach((key, val) -> {
                if (!(MessageConst.STRING_HASH_SET.contains(key) || "id".equals(key) || "timestamp".equals(key))) {
                    messageBuilder.setHeader(key, val);
                }
            });
        }
    }

    public static Message convertMessage2MQ(String destination, org.springframework.messaging.Message<?> source) {
        org.springframework.messaging.Message message = MESSAGE_CONVERTER.toMessage(source.getPayload(), source.getHeaders());
        assert (message != null);
        MessageBuilder builder = MessageBuilder.fromMessage((org.springframework.messaging.Message)message);
        builder.setHeaderIfAbsent("contentType", (Object)MimeTypeUtils.TEXT_PLAIN);
        message = builder.build();
        return RocketMQMessageConverterSupport.doConvert(destination, message);
    }

    private static Message doConvert(String topic, org.springframework.messaging.Message<?> message) {
        byte[] payloads;
        Charset charset = Charset.defaultCharset();
        Object payloadObj = message.getPayload();
        try {
            if (payloadObj instanceof String) {
                payloads = ((String)payloadObj).getBytes(charset);
            } else if (payloadObj instanceof byte[]) {
                payloads = (byte[])message.getPayload();
            } else {
                String jsonObj = (String)MESSAGE_CONVERTER.fromMessage(message, payloadObj.getClass());
                if (null == jsonObj) {
                    throw new RuntimeException(String.format("empty after conversion [messageConverter:%s,payloadClass:%s,payloadObj:%s]", MESSAGE_CONVERTER.getClass(), payloadObj.getClass(), payloadObj));
                }
                payloads = jsonObj.getBytes(charset);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("convert to RocketMQ message failed.", e);
        }
        return RocketMQMessageConverterSupport.getAndWrapMessage(topic, message.getHeaders(), payloads);
    }

    private static Message getAndWrapMessage(String topic, MessageHeaders headers, byte[] payloads) {
        if (topic == null || topic.length() < 1) {
            return null;
        }
        if (payloads == null || payloads.length < 1) {
            return null;
        }
        Message rocketMsg = new Message(topic, payloads);
        if (Objects.nonNull(headers) && !headers.isEmpty()) {
            Object keys;
            Object tag = headers.getOrDefault((Object)"TAGS", headers.get((Object)RocketMQMessageConverterSupport.toRocketHeaderKey("TAGS")));
            if (!ObjectUtils.isEmpty((Object)tag)) {
                rocketMsg.setTags(String.valueOf(tag));
            }
            if (!ObjectUtils.isEmpty((Object)(keys = headers.getOrDefault((Object)"KEYS", headers.get((Object)RocketMQMessageConverterSupport.toRocketHeaderKey("KEYS")))))) {
                rocketMsg.setKeys(keys.toString());
            }
            Object flagObj = headers.getOrDefault((Object)"MQ_FLAG", headers.get((Object)RocketMQMessageConverterSupport.toRocketHeaderKey("MQ_FLAG")));
            int flag = 0;
            int delayLevel = 0;
            try {
                flagObj = flagObj == null ? Integer.valueOf(0) : flagObj;
                Object delayLevelObj = headers.getOrDefault((Object)"DELAY", headers.get((Object)RocketMQMessageConverterSupport.toRocketHeaderKey("DELAY")));
                delayLevelObj = delayLevelObj == null ? Integer.valueOf(0) : delayLevelObj;
                delayLevel = Integer.parseInt(String.valueOf(delayLevelObj));
                flag = Integer.parseInt(String.valueOf(flagObj));
            }
            catch (Exception delayLevelObj) {
                // empty catch block
            }
            if (delayLevel > 0) {
                rocketMsg.setDelayTimeLevel(delayLevel);
            }
            rocketMsg.setFlag(flag);
            Object waitStoreMsgOkObj = headers.getOrDefault((Object)"WAIT", (Object)"true");
            rocketMsg.setWaitStoreMsgOK(Boolean.parseBoolean(String.valueOf(waitStoreMsgOkObj)));
            headers.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), "MQ_FLAG")).forEach(entry -> {
                String val;
                if (!MessageConst.STRING_HASH_SET.contains(entry.getKey()) && StringUtils.isNotBlank((CharSequence)(val = String.valueOf(entry.getValue())))) {
                    rocketMsg.putUserProperty((String)entry.getKey(), val);
                }
            });
        }
        return rocketMsg;
    }
}

