/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.catchlog;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="colaCatchLogApplicationContextHelper")
public class ApplicationContextHelper
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ApplicationContextHelper.class);
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHelper.applicationContext = applicationContext;
    }

    public static <T> T getBean(Class<T> targetClz) {
        Object beanInstance = null;
        try {
            beanInstance = applicationContext.getBean(targetClz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (beanInstance == null) {
                Object simpleName = targetClz.getSimpleName();
                simpleName = Character.toLowerCase(((String)simpleName).charAt(0)) + ((String)simpleName).substring(1);
                beanInstance = applicationContext.getBean((String)simpleName);
            }
        }
        catch (Exception e) {
            log.warn("No bean found for " + targetClz.getCanonicalName());
        }
        return (T)beanInstance;
    }

    public static Object getBean(String claz) {
        return applicationContext.getBean(claz);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        return (T)applicationContext.getBean(name, requiredType);
    }

    public static <T> T getBean(Class<T> requiredType, Object ... params) {
        return (T)applicationContext.getBean(requiredType, params);
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

