/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.tokenizers;

import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.tokenizers.TokenizationOutput;
import com.alibaba.dashscope.tokenizers.TokenizationUsage;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenizationResult {
    private static final Logger log = LoggerFactory.getLogger(TokenizationResult.class);
    private String requestId;
    private TokenizationUsage usage;
    private TokenizationOutput output;

    private TokenizationResult() {
    }

    public static TokenizationResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        TokenizationResult result = new TokenizationResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.usage = JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), TokenizationUsage.class);
        }
        if (dashScopeResult.getOutput() != null) {
            result.output = JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), TokenizationOutput.class);
        } else {
            log.error(String.format("Result no output: %s", dashScopeResult));
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public TokenizationUsage getUsage() {
        return this.usage;
    }

    public TokenizationOutput getOutput() {
        return this.output;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setUsage(TokenizationUsage usage) {
        this.usage = usage;
    }

    public void setOutput(TokenizationOutput output) {
        this.output = output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenizationResult)) {
            return false;
        }
        TokenizationResult other = (TokenizationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        TokenizationUsage this$usage = this.getUsage();
        TokenizationUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        TokenizationOutput this$output = this.getOutput();
        TokenizationOutput other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenizationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        TokenizationUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        TokenizationOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    public String toString() {
        return "TokenizationResult(requestId=" + this.getRequestId() + ", usage=" + this.getUsage() + ", output=" + this.getOutput() + ")";
    }
}

