/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.audio.asr.recognition.Recognition;
import com.alibaba.dashscope.audio.asr.recognition.RecognitionParam;
import com.alibaba.dashscope.audio.asr.recognition.RecognitionResult;
import com.alibaba.dashscope.base.FullDuplexParamBase;
import com.alibaba.dashscope.base.FullDuplexServiceParam;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public final class AudioRecognitionUsage {
    private final AudioFormat format = this.buildAudioFormatInstance();
    private volatile boolean stopped;

    public TargetDataLine getTargetDataLineForRecord() throws LineUnavailableException {
        TargetDataLine microphone = AudioSystem.getTargetDataLine(this.format);
        System.out.println(microphone.getBufferSize());
        microphone.open();
        return microphone;
    }

    public Flowable<ByteBuffer> getMicrophoneStreaming() {
        Flowable audios = Flowable.create(emitter -> {
            try {
                int numBytesRead;
                TargetDataLine line = this.getTargetDataLineForRecord();
                int frameSizeInBytes = this.format.getFrameSize();
                System.out.println(String.format("Frame size in bytes: %s, %s", frameSizeInBytes, this.format.getEncoding()));
                int bufferLengthInBytes = 1024 * frameSizeInBytes;
                line.start();
                byte[] data = new byte[bufferLengthInBytes];
                for (int c = 0; !this.stopped && c < 100 && (numBytesRead = line.read(data, 0, bufferLengthInBytes)) != -1; ++c) {
                    System.out.println(String.format("Read microphone %s data", numBytesRead));
                    emitter.onNext((Object)ByteBuffer.wrap(data, 0, numBytesRead));
                    if (c % 10 != 0) continue;
                    System.out.println(String.format("Sending %d packages", c));
                }
                emitter.onComplete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                emitter.onError((Throwable)ex);
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        return audios;
    }

    public AudioFormat buildAudioFormatInstance() {
        AudioFormat.Encoding ENCODING = AudioFormat.Encoding.PCM_SIGNED;
        float RATE = 16000.0f;
        boolean CHANNELS = true;
        int SAMPLE_SIZE = 16;
        boolean BIG_ENDIAN = false;
        return new AudioFormat(ENCODING, 16000.0f, 16, 1, 2, 16000.0f, false);
    }

    public Flowable<ByteBuffer> getStreamingDataFromFile(String filePath) {
        Flowable audios = Flowable.create(emmitter -> {
            int totalFramesRead = 0;
            File fileIn = new File(filePath);
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(fileIn);
                int bytesPerFrame = audioInputStream.getFormat().getFrameSize();
                System.out.println(String.format("BytesPerFrame: %s", bytesPerFrame));
                int numBytes = 1024 * bytesPerFrame;
                byte[] audioBytes = new byte[numBytes];
                try {
                    int numBytesRead = 0;
                    int numFramesRead = 0;
                    while ((numBytesRead = audioInputStream.read(audioBytes)) != -1) {
                        numFramesRead = numBytesRead / bytesPerFrame;
                        totalFramesRead += numFramesRead;
                        emmitter.onNext((Object)ByteBuffer.wrap(audioBytes, 0, numBytesRead));
                    }
                    emmitter.onComplete();
                    System.out.println(String.format("Total frames: %d", totalFramesRead));
                }
                catch (Exception ex) {
                    emmitter.onError((Throwable)ex);
                }
            }
            catch (Exception e) {
                emmitter.onError((Throwable)e);
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).subscribeOn(Schedulers.io());
        return audios;
    }

    public void recognitionFile(String filePath) throws ApiException, NoApiKeyException {
        FullDuplexServiceParam param = ((RecognitionParam.RecognitionParamBuilder)((RecognitionParam.RecognitionParamBuilder)((FullDuplexParamBase.FullDuplexParamBaseBuilder)RecognitionParam.builder().format("pcm")).model("paraformer-realtime-v1")).sampleRate(16000)).build();
        Recognition rg = new Recognition();
        Flowable<RecognitionResult> resultFlowable = rg.streamCall((RecognitionParam)param, this.getStreamingDataFromFile(filePath));
        resultFlowable.blockingForEach(message -> System.out.println(message));
    }

    public void recognitionRealtimeMicrophone() throws ApiException, NoApiKeyException {
        FullDuplexServiceParam param = ((RecognitionParam.RecognitionParamBuilder)((RecognitionParam.RecognitionParamBuilder)((FullDuplexParamBase.FullDuplexParamBaseBuilder)RecognitionParam.builder().format("pcm")).model("paraformer-realtime-v1")).sampleRate(16000)).build();
        Recognition rg = new Recognition();
        Flowable<RecognitionResult> resultFlowable = rg.streamCall((RecognitionParam)param, this.getMicrophoneStreaming());
        resultFlowable.doOnError(err -> {
            this.stopped = true;
            System.out.println(err);
        }).blockingForEach(message -> System.out.println(message));
    }

    public static void main(String[] args) {
        String filePath = "./src/test/resources/asr_example_cn_en.wav";
        AudioRecognitionUsage audioRecognition = new AudioRecognitionUsage();
        try {
            audioRecognition.recognitionFile(filePath);
            audioRecognition.recognitionRealtimeMicrophone();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }
}

