/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.ttsv2;

import com.alibaba.dashscope.audio.tts.SpeechSynthesisTextType;
import com.alibaba.dashscope.audio.ttsv2.SpeechSynthesisAudioFormat;
import com.alibaba.dashscope.base.FullDuplexServiceParam;
import io.reactivex.Flowable;
import java.util.HashMap;
import java.util.Map;

public class SpeechSynthesisParam
extends FullDuplexServiceParam {
    private SpeechSynthesisTextType textType;
    private String voice;
    private SpeechSynthesisAudioFormat format;
    private int volume;
    private float speechRate;
    private float pitchRate;
    private boolean enableWordTimestamp;
    private boolean enablePhonemeTimestamp;

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("voice", this.getVoice());
        params.put("text_type", this.getTextType().getValue());
        params.put("format", this.getFormat().getFormat());
        params.put("sample_rate", this.getFormat().getSampleRate());
        params.put("volume", this.getVolume());
        params.put("rate", Float.valueOf(this.getSpeechRate()));
        params.put("pitch", Float.valueOf(this.getPitchRate()));
        params.put("word_timestamp_enabled", this.isEnableWordTimestamp());
        params.put("phoneme_timestamp_enabled", this.isEnablePhonemeTimestamp());
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public Object getResources() {
        return null;
    }

    @Override
    public Flowable<Object> getStreamingData() {
        return null;
    }

    private static SpeechSynthesisTextType $default$textType() {
        return SpeechSynthesisTextType.PLAIN_TEXT;
    }

    private static String $default$voice() {
        return "";
    }

    private static SpeechSynthesisAudioFormat $default$format() {
        return SpeechSynthesisAudioFormat.DEFAULT;
    }

    private static int $default$volume() {
        return 50;
    }

    private static float $default$speechRate() {
        return 1.0f;
    }

    private static float $default$pitchRate() {
        return 1.0f;
    }

    private static boolean $default$enableWordTimestamp() {
        return false;
    }

    private static boolean $default$enablePhonemeTimestamp() {
        return false;
    }

    protected SpeechSynthesisParam(SpeechSynthesisParamBuilder<?, ?> b) {
        super((FullDuplexServiceParam.FullDuplexServiceParamBuilder<?, ?>)b);
        this.textType = ((SpeechSynthesisParamBuilder)b).textType$set ? ((SpeechSynthesisParamBuilder)b).textType$value : SpeechSynthesisParam.$default$textType();
        this.voice = ((SpeechSynthesisParamBuilder)b).voice$set ? ((SpeechSynthesisParamBuilder)b).voice$value : SpeechSynthesisParam.$default$voice();
        this.format = ((SpeechSynthesisParamBuilder)b).format$set ? ((SpeechSynthesisParamBuilder)b).format$value : SpeechSynthesisParam.$default$format();
        this.volume = ((SpeechSynthesisParamBuilder)b).volume$set ? ((SpeechSynthesisParamBuilder)b).volume$value : SpeechSynthesisParam.$default$volume();
        this.speechRate = ((SpeechSynthesisParamBuilder)b).speechRate$set ? ((SpeechSynthesisParamBuilder)b).speechRate$value : SpeechSynthesisParam.$default$speechRate();
        this.pitchRate = ((SpeechSynthesisParamBuilder)b).pitchRate$set ? ((SpeechSynthesisParamBuilder)b).pitchRate$value : SpeechSynthesisParam.$default$pitchRate();
        this.enableWordTimestamp = ((SpeechSynthesisParamBuilder)b).enableWordTimestamp$set ? ((SpeechSynthesisParamBuilder)b).enableWordTimestamp$value : SpeechSynthesisParam.$default$enableWordTimestamp();
        this.enablePhonemeTimestamp = ((SpeechSynthesisParamBuilder)b).enablePhonemeTimestamp$set ? ((SpeechSynthesisParamBuilder)b).enablePhonemeTimestamp$value : SpeechSynthesisParam.$default$enablePhonemeTimestamp();
    }

    public static SpeechSynthesisParamBuilder<?, ?> builder() {
        return new SpeechSynthesisParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpeechSynthesisParam)) {
            return false;
        }
        SpeechSynthesisParam other = (SpeechSynthesisParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVolume() != other.getVolume()) {
            return false;
        }
        if (Float.compare(this.getSpeechRate(), other.getSpeechRate()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitchRate(), other.getPitchRate()) != 0) {
            return false;
        }
        if (this.isEnableWordTimestamp() != other.isEnableWordTimestamp()) {
            return false;
        }
        if (this.isEnablePhonemeTimestamp() != other.isEnablePhonemeTimestamp()) {
            return false;
        }
        SpeechSynthesisTextType this$textType = this.getTextType();
        SpeechSynthesisTextType other$textType = other.getTextType();
        if (this$textType == null ? other$textType != null : !((Object)((Object)this$textType)).equals((Object)other$textType)) {
            return false;
        }
        String this$voice = this.getVoice();
        String other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !this$voice.equals(other$voice)) {
            return false;
        }
        SpeechSynthesisAudioFormat this$format = this.getFormat();
        SpeechSynthesisAudioFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpeechSynthesisParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getVolume();
        result = result * 59 + Float.floatToIntBits(this.getSpeechRate());
        result = result * 59 + Float.floatToIntBits(this.getPitchRate());
        result = result * 59 + (this.isEnableWordTimestamp() ? 79 : 97);
        result = result * 59 + (this.isEnablePhonemeTimestamp() ? 79 : 97);
        SpeechSynthesisTextType $textType = this.getTextType();
        result = result * 59 + ($textType == null ? 43 : ((Object)((Object)$textType)).hashCode());
        String $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : $voice.hashCode());
        SpeechSynthesisAudioFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        return result;
    }

    public SpeechSynthesisTextType getTextType() {
        return this.textType;
    }

    public String getVoice() {
        return this.voice;
    }

    public SpeechSynthesisAudioFormat getFormat() {
        return this.format;
    }

    public int getVolume() {
        return this.volume;
    }

    public float getSpeechRate() {
        return this.speechRate;
    }

    public float getPitchRate() {
        return this.pitchRate;
    }

    public boolean isEnableWordTimestamp() {
        return this.enableWordTimestamp;
    }

    public boolean isEnablePhonemeTimestamp() {
        return this.enablePhonemeTimestamp;
    }

    public void setTextType(SpeechSynthesisTextType textType) {
        this.textType = textType;
    }

    public void setVoice(String voice) {
        this.voice = voice;
    }

    public void setFormat(SpeechSynthesisAudioFormat format) {
        this.format = format;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setSpeechRate(float speechRate) {
        this.speechRate = speechRate;
    }

    public void setPitchRate(float pitchRate) {
        this.pitchRate = pitchRate;
    }

    public void setEnableWordTimestamp(boolean enableWordTimestamp) {
        this.enableWordTimestamp = enableWordTimestamp;
    }

    public void setEnablePhonemeTimestamp(boolean enablePhonemeTimestamp) {
        this.enablePhonemeTimestamp = enablePhonemeTimestamp;
    }

    @Override
    public String toString() {
        return "SpeechSynthesisParam(textType=" + (Object)((Object)this.getTextType()) + ", voice=" + this.getVoice() + ", format=" + (Object)((Object)this.getFormat()) + ", volume=" + this.getVolume() + ", speechRate=" + this.getSpeechRate() + ", pitchRate=" + this.getPitchRate() + ", enableWordTimestamp=" + this.isEnableWordTimestamp() + ", enablePhonemeTimestamp=" + this.isEnablePhonemeTimestamp() + ")";
    }

    private static final class SpeechSynthesisParamBuilderImpl
    extends SpeechSynthesisParamBuilder<SpeechSynthesisParam, SpeechSynthesisParamBuilderImpl> {
        private SpeechSynthesisParamBuilderImpl() {
        }

        @Override
        protected SpeechSynthesisParamBuilderImpl self() {
            return this;
        }

        @Override
        public SpeechSynthesisParam build() {
            return new SpeechSynthesisParam(this);
        }
    }

    public static abstract class SpeechSynthesisParamBuilder<C extends SpeechSynthesisParam, B extends SpeechSynthesisParamBuilder<C, B>>
    extends FullDuplexServiceParam.FullDuplexServiceParamBuilder<C, B> {
        private boolean textType$set;
        private SpeechSynthesisTextType textType$value;
        private boolean voice$set;
        private String voice$value;
        private boolean format$set;
        private SpeechSynthesisAudioFormat format$value;
        private boolean volume$set;
        private int volume$value;
        private boolean speechRate$set;
        private float speechRate$value;
        private boolean pitchRate$set;
        private float pitchRate$value;
        private boolean enableWordTimestamp$set;
        private boolean enableWordTimestamp$value;
        private boolean enablePhonemeTimestamp$set;
        private boolean enablePhonemeTimestamp$value;

        public B textType(SpeechSynthesisTextType textType) {
            this.textType$value = textType;
            this.textType$set = true;
            return (B)this.self();
        }

        public B voice(String voice) {
            this.voice$value = voice;
            this.voice$set = true;
            return (B)this.self();
        }

        public B format(SpeechSynthesisAudioFormat format) {
            this.format$value = format;
            this.format$set = true;
            return (B)this.self();
        }

        public B volume(int volume) {
            this.volume$value = volume;
            this.volume$set = true;
            return (B)this.self();
        }

        public B speechRate(float speechRate) {
            this.speechRate$value = speechRate;
            this.speechRate$set = true;
            return (B)this.self();
        }

        public B pitchRate(float pitchRate) {
            this.pitchRate$value = pitchRate;
            this.pitchRate$set = true;
            return (B)this.self();
        }

        public B enableWordTimestamp(boolean enableWordTimestamp) {
            this.enableWordTimestamp$value = enableWordTimestamp;
            this.enableWordTimestamp$set = true;
            return (B)this.self();
        }

        public B enablePhonemeTimestamp(boolean enablePhonemeTimestamp) {
            this.enablePhonemeTimestamp$value = enablePhonemeTimestamp;
            this.enablePhonemeTimestamp$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SpeechSynthesisParam.SpeechSynthesisParamBuilder(super=" + super.toString() + ", textType$value=" + (Object)((Object)this.textType$value) + ", voice$value=" + this.voice$value + ", format$value=" + (Object)((Object)this.format$value) + ", volume$value=" + this.volume$value + ", speechRate$value=" + this.speechRate$value + ", pitchRate$value=" + this.pitchRate$value + ", enableWordTimestamp$value=" + this.enableWordTimestamp$value + ", enablePhonemeTimestamp$value=" + this.enablePhonemeTimestamp$value + ")";
        }
    }
}

