/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.utils.EncryptionConfig;
import com.alibaba.dashscope.utils.EncryptionKey;
import com.alibaba.dashscope.utils.EncryptionKeys;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class EncryptionUtils {
    private static final String algorithm = "AES/GCM/NoPadding";
    private static final Integer keyLength = 256;

    public static String RSAEncrypt(String input, String base64AESEncryptKey) throws ApiException {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            byte[] keyBytes = Base64.getDecoder().decode(base64AESEncryptKey);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            cipher.init(1, kf.generatePublic(spec));
            byte[] cipherBytes = cipher.doFinal(input.getBytes());
            return Base64.getEncoder().encodeToString(cipherBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ApiException(e);
        }
    }

    public static SecretKey generateAESKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = new SecureRandom();
            keyGenerator.init(keyLength, secureRandom);
            SecretKey key = keyGenerator.generateKey();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApiException(e);
        }
    }

    public static String AESEncrypt(String input, SecretKey secretKey, byte[] iv) throws ApiException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, gcmParameterSpec);
            byte[] cipherInput = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(cipherInput);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ApiException(e);
        }
    }

    public static String AESEncrypt(byte[] input, SecretKey secretKey, byte[] iv) throws ApiException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, gcmParameterSpec);
            byte[] cipherInput = cipher.doFinal(input);
            return Base64.getEncoder().encodeToString(cipherInput);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ApiException(e);
        }
    }

    public static String AESDecrypt(String cipherText, SecretKey secretKey, byte[] iv) throws ApiException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKey, gcmParameterSpec);
            byte[] plainText = cipher.doFinal(Base64.getDecoder().decode(cipherText));
            return new String(plainText, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ApiException(e);
        }
    }

    public static EncryptionConfig generateEncryptionConfig() throws ApiException, NoApiKeyException {
        EncryptionKeys encryptionKeys = new EncryptionKeys();
        EncryptionKey encryptionKey = encryptionKeys.get();
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        Object encryptionConfig = ((EncryptionConfig.EncryptionConfigBuilder)((EncryptionConfig.EncryptionConfigBuilder)((EncryptionConfig.EncryptionConfigBuilder)((EncryptionConfig.EncryptionConfigBuilder)EncryptionConfig.builder().base64PublicKey(encryptionKey.getPublicKey())).publicKeyId(encryptionKey.getPublicKeyId())).AESEncryptKey(EncryptionUtils.generateAESKey())).iv(iv)).build();
        return encryptionConfig;
    }
}

