/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.qwen_tts_realtime;

import com.alibaba.dashscope.audio.qwen_tts_realtime.QwenTtsRealtimeAudioFormat;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class QwenTtsRealtimeConfig {
    @NonNull
    String voice;
    QwenTtsRealtimeAudioFormat responseFormat;
    String mode;
    String languageType;
    Integer sampleRate;
    Float speechRate;
    Integer volume;
    String format;
    Float pitchRate;
    Integer bitRate;
    Map<String, Object> parameters;

    public JsonObject getConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("voice", this.voice);
        config.put("mode", this.mode);
        if (this.format != null) {
            config.put("response_format", this.format);
        } else {
            config.put("response_format", this.responseFormat.getFormat());
        }
        if (this.sampleRate != null) {
            config.put("sample_rate", this.sampleRate);
        } else {
            config.put("sample_rate", this.responseFormat.getSampleRate());
        }
        if (this.speechRate != null) {
            config.put("speech_rate", this.speechRate);
        }
        if (this.pitchRate != null) {
            config.put("pitch_rate", this.pitchRate);
        }
        if (this.volume != null) {
            config.put("volume", this.volume);
        }
        if (this.bitRate != null) {
            config.put("bit_rate", this.bitRate);
        }
        if (this.languageType != null) {
            config.put("language_type", this.languageType);
        }
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                config.put(entry.getKey(), entry.getValue());
            }
        }
        JsonObject jsonObject = JsonUtils.gson.toJsonTree(config).getAsJsonObject();
        return jsonObject;
    }

    private static QwenTtsRealtimeAudioFormat $default$responseFormat() {
        return QwenTtsRealtimeAudioFormat.PCM_24000HZ_MONO_16BIT;
    }

    private static String $default$mode() {
        return "server_commit";
    }

    private static String $default$languageType() {
        return null;
    }

    private static Integer $default$sampleRate() {
        return null;
    }

    private static Float $default$speechRate() {
        return null;
    }

    private static Integer $default$volume() {
        return null;
    }

    private static String $default$format() {
        return null;
    }

    private static Float $default$pitchRate() {
        return null;
    }

    private static Integer $default$bitRate() {
        return null;
    }

    private static Map<String, Object> $default$parameters() {
        return null;
    }

    protected QwenTtsRealtimeConfig(QwenTtsRealtimeConfigBuilder<?, ?> b) {
        this.voice = ((QwenTtsRealtimeConfigBuilder)b).voice;
        if (this.voice == null) {
            throw new NullPointerException("voice is marked non-null but is null");
        }
        this.responseFormat = ((QwenTtsRealtimeConfigBuilder)b).responseFormat$set ? ((QwenTtsRealtimeConfigBuilder)b).responseFormat$value : QwenTtsRealtimeConfig.$default$responseFormat();
        this.mode = ((QwenTtsRealtimeConfigBuilder)b).mode$set ? ((QwenTtsRealtimeConfigBuilder)b).mode$value : QwenTtsRealtimeConfig.$default$mode();
        this.languageType = ((QwenTtsRealtimeConfigBuilder)b).languageType$set ? ((QwenTtsRealtimeConfigBuilder)b).languageType$value : QwenTtsRealtimeConfig.$default$languageType();
        this.sampleRate = ((QwenTtsRealtimeConfigBuilder)b).sampleRate$set ? ((QwenTtsRealtimeConfigBuilder)b).sampleRate$value : QwenTtsRealtimeConfig.$default$sampleRate();
        this.speechRate = ((QwenTtsRealtimeConfigBuilder)b).speechRate$set ? ((QwenTtsRealtimeConfigBuilder)b).speechRate$value : QwenTtsRealtimeConfig.$default$speechRate();
        this.volume = ((QwenTtsRealtimeConfigBuilder)b).volume$set ? ((QwenTtsRealtimeConfigBuilder)b).volume$value : QwenTtsRealtimeConfig.$default$volume();
        this.format = ((QwenTtsRealtimeConfigBuilder)b).format$set ? ((QwenTtsRealtimeConfigBuilder)b).format$value : QwenTtsRealtimeConfig.$default$format();
        this.pitchRate = ((QwenTtsRealtimeConfigBuilder)b).pitchRate$set ? ((QwenTtsRealtimeConfigBuilder)b).pitchRate$value : QwenTtsRealtimeConfig.$default$pitchRate();
        this.bitRate = ((QwenTtsRealtimeConfigBuilder)b).bitRate$set ? ((QwenTtsRealtimeConfigBuilder)b).bitRate$value : QwenTtsRealtimeConfig.$default$bitRate();
        this.parameters = ((QwenTtsRealtimeConfigBuilder)b).parameters$set ? ((QwenTtsRealtimeConfigBuilder)b).parameters$value : QwenTtsRealtimeConfig.$default$parameters();
    }

    public static QwenTtsRealtimeConfigBuilder<?, ?> builder() {
        return new QwenTtsRealtimeConfigBuilderImpl();
    }

    @NonNull
    public String getVoice() {
        return this.voice;
    }

    public QwenTtsRealtimeAudioFormat getResponseFormat() {
        return this.responseFormat;
    }

    public String getMode() {
        return this.mode;
    }

    public String getLanguageType() {
        return this.languageType;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public Float getSpeechRate() {
        return this.speechRate;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public String getFormat() {
        return this.format;
    }

    public Float getPitchRate() {
        return this.pitchRate;
    }

    public Integer getBitRate() {
        return this.bitRate;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setVoice(@NonNull String voice) {
        if (voice == null) {
            throw new NullPointerException("voice is marked non-null but is null");
        }
        this.voice = voice;
    }

    public void setResponseFormat(QwenTtsRealtimeAudioFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setLanguageType(String languageType) {
        this.languageType = languageType;
    }

    public void setSampleRate(Integer sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setSpeechRate(Float speechRate) {
        this.speechRate = speechRate;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setPitchRate(Float pitchRate) {
        this.pitchRate = pitchRate;
    }

    public void setBitRate(Integer bitRate) {
        this.bitRate = bitRate;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QwenTtsRealtimeConfig)) {
            return false;
        }
        QwenTtsRealtimeConfig other = (QwenTtsRealtimeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sampleRate = this.getSampleRate();
        Integer other$sampleRate = other.getSampleRate();
        if (this$sampleRate == null ? other$sampleRate != null : !((Object)this$sampleRate).equals(other$sampleRate)) {
            return false;
        }
        Float this$speechRate = this.getSpeechRate();
        Float other$speechRate = other.getSpeechRate();
        if (this$speechRate == null ? other$speechRate != null : !((Object)this$speechRate).equals(other$speechRate)) {
            return false;
        }
        Integer this$volume = this.getVolume();
        Integer other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume)) {
            return false;
        }
        Float this$pitchRate = this.getPitchRate();
        Float other$pitchRate = other.getPitchRate();
        if (this$pitchRate == null ? other$pitchRate != null : !((Object)this$pitchRate).equals(other$pitchRate)) {
            return false;
        }
        Integer this$bitRate = this.getBitRate();
        Integer other$bitRate = other.getBitRate();
        if (this$bitRate == null ? other$bitRate != null : !((Object)this$bitRate).equals(other$bitRate)) {
            return false;
        }
        String this$voice = this.getVoice();
        String other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !this$voice.equals(other$voice)) {
            return false;
        }
        QwenTtsRealtimeAudioFormat this$responseFormat = this.getResponseFormat();
        QwenTtsRealtimeAudioFormat other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !((Object)((Object)this$responseFormat)).equals((Object)other$responseFormat)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$languageType = this.getLanguageType();
        String other$languageType = other.getLanguageType();
        if (this$languageType == null ? other$languageType != null : !this$languageType.equals(other$languageType)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QwenTtsRealtimeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sampleRate = this.getSampleRate();
        result = result * 59 + ($sampleRate == null ? 43 : ((Object)$sampleRate).hashCode());
        Float $speechRate = this.getSpeechRate();
        result = result * 59 + ($speechRate == null ? 43 : ((Object)$speechRate).hashCode());
        Integer $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
        Float $pitchRate = this.getPitchRate();
        result = result * 59 + ($pitchRate == null ? 43 : ((Object)$pitchRate).hashCode());
        Integer $bitRate = this.getBitRate();
        result = result * 59 + ($bitRate == null ? 43 : ((Object)$bitRate).hashCode());
        String $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : $voice.hashCode());
        QwenTtsRealtimeAudioFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)((Object)$responseFormat)).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $languageType = this.getLanguageType();
        result = result * 59 + ($languageType == null ? 43 : $languageType.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "QwenTtsRealtimeConfig(voice=" + this.getVoice() + ", responseFormat=" + (Object)((Object)this.getResponseFormat()) + ", mode=" + this.getMode() + ", languageType=" + this.getLanguageType() + ", sampleRate=" + this.getSampleRate() + ", speechRate=" + this.getSpeechRate() + ", volume=" + this.getVolume() + ", format=" + this.getFormat() + ", pitchRate=" + this.getPitchRate() + ", bitRate=" + this.getBitRate() + ", parameters=" + this.getParameters() + ")";
    }

    private static final class QwenTtsRealtimeConfigBuilderImpl
    extends QwenTtsRealtimeConfigBuilder<QwenTtsRealtimeConfig, QwenTtsRealtimeConfigBuilderImpl> {
        private QwenTtsRealtimeConfigBuilderImpl() {
        }

        @Override
        protected QwenTtsRealtimeConfigBuilderImpl self() {
            return this;
        }

        @Override
        public QwenTtsRealtimeConfig build() {
            return new QwenTtsRealtimeConfig(this);
        }
    }

    public static abstract class QwenTtsRealtimeConfigBuilder<C extends QwenTtsRealtimeConfig, B extends QwenTtsRealtimeConfigBuilder<C, B>> {
        private String voice;
        private boolean responseFormat$set;
        private QwenTtsRealtimeAudioFormat responseFormat$value;
        private boolean mode$set;
        private String mode$value;
        private boolean languageType$set;
        private String languageType$value;
        private boolean sampleRate$set;
        private Integer sampleRate$value;
        private boolean speechRate$set;
        private Float speechRate$value;
        private boolean volume$set;
        private Integer volume$value;
        private boolean format$set;
        private String format$value;
        private boolean pitchRate$set;
        private Float pitchRate$value;
        private boolean bitRate$set;
        private Integer bitRate$value;
        private boolean parameters$set;
        private Map<String, Object> parameters$value;

        public B voice(@NonNull String voice) {
            if (voice == null) {
                throw new NullPointerException("voice is marked non-null but is null");
            }
            this.voice = voice;
            return this.self();
        }

        public B responseFormat(QwenTtsRealtimeAudioFormat responseFormat) {
            this.responseFormat$value = responseFormat;
            this.responseFormat$set = true;
            return this.self();
        }

        public B mode(String mode) {
            this.mode$value = mode;
            this.mode$set = true;
            return this.self();
        }

        public B languageType(String languageType) {
            this.languageType$value = languageType;
            this.languageType$set = true;
            return this.self();
        }

        public B sampleRate(Integer sampleRate) {
            this.sampleRate$value = sampleRate;
            this.sampleRate$set = true;
            return this.self();
        }

        public B speechRate(Float speechRate) {
            this.speechRate$value = speechRate;
            this.speechRate$set = true;
            return this.self();
        }

        public B volume(Integer volume) {
            this.volume$value = volume;
            this.volume$set = true;
            return this.self();
        }

        public B format(String format) {
            this.format$value = format;
            this.format$set = true;
            return this.self();
        }

        public B pitchRate(Float pitchRate) {
            this.pitchRate$value = pitchRate;
            this.pitchRate$set = true;
            return this.self();
        }

        public B bitRate(Integer bitRate) {
            this.bitRate$value = bitRate;
            this.bitRate$set = true;
            return this.self();
        }

        public B parameters(Map<String, Object> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "QwenTtsRealtimeConfig.QwenTtsRealtimeConfigBuilder(voice=" + this.voice + ", responseFormat$value=" + (Object)((Object)this.responseFormat$value) + ", mode$value=" + this.mode$value + ", languageType$value=" + this.languageType$value + ", sampleRate$value=" + this.sampleRate$value + ", speechRate$value=" + this.speechRate$value + ", volume$value=" + this.volume$value + ", format$value=" + this.format$value + ", pitchRate$value=" + this.pitchRate$value + ", bitRate$value=" + this.bitRate$value + ", parameters$value=" + this.parameters$value + ")";
        }
    }
}

