/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.util.ListUtils;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;

public class PageReadListener<T>
implements ReadListener<T> {
    public static int BATCH_COUNT = 3000;
    private List<T> cachedData = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
    private final Consumer<List<T>> consumer;

    public PageReadListener(Consumer<List<T>> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void invoke(T data, AnalysisContext context) {
        this.cachedData.add(data);
        if (this.cachedData.size() >= BATCH_COUNT) {
            this.consumer.accept(this.cachedData);
            this.cachedData = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        if (CollectionUtils.isNotEmpty(this.cachedData)) {
            this.consumer.accept(this.cachedData);
        }
    }
}

