package com.alibaba.metrics;

import java.lang.reflect.Method;

/**
 * The design concept is heavily borrowed from SLF4j, the logging framework.
 * The application only depends on the metrics api.
 * The implementation is dynamically bound.
 * @author wangtao 2016-06-17 10:27.
 */
public class MetricManager {

    private static final String BINDER_CLASS = "com.alibaba.metrics.MetricManagerBinder";

    private static final IMetricManager NOP_METRIC_MANAGER = new NOPMetricManager();

    private static volatile IMetricManager iMetricManager;

    public static Meter getMeter(String group, MetricName name) {
        IMetricManager manager = getIMetricManager();
        return manager.getMeter(group, name);
    }

    public static Counter getCounter(String group, MetricName name) {
        IMetricManager manager = getIMetricManager();
        return manager.getCounter(group, name);
    }

    public static Histogram getHistogram(String group, MetricName name) {
        IMetricManager manager = getIMetricManager();
        return manager.getHistogram(group, name);
    }

    public static Timer getTimer(String group, MetricName name) {
        IMetricManager manager = getIMetricManager();
        return manager.getTimer(group, name);
    }

    public static void register(String group, MetricName name, Metric metric) {
        IMetricManager manager = getIMetricManager();
        manager.register(group, name, metric);
    }

    @SuppressWarnings("unchecked")
    public static IMetricManager getIMetricManager() {
        if (iMetricManager == null) {
            synchronized (MetricManager.class) {
                if (iMetricManager == null) {
                    try {
                        Class binderClazz = MetricManager.class.getClassLoader().loadClass(BINDER_CLASS);
                        Method getSingleton = binderClazz.getMethod("getSingleton");
                        Object binderObject = getSingleton.invoke(null);
                        Method getMetricManager = binderClazz.getMethod("getMetricManager");
                        iMetricManager = (IMetricManager) getMetricManager.invoke(binderObject);
                    } catch (Exception e) {
                        return NOP_METRIC_MANAGER;
                    }
                }
            }
        }
        return iMetricManager;
    }

}
