package com.alibaba.metrics;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/**
 * @author wangtao 2016-06-20 11:56.
 */
public interface IMetricManager {

    /**
     * Create a {@link Meter} metric in given group, and name.
     * if not exist, an instance will be created.
     *
     * @param group the group of MetricRegistry
     * @param name the name of the metric
     * @return an instance of meter,
     */
    Meter getMeter(String group, MetricName name);

    /**
     * Create a {@link Counter} metric in given group, and name.
     * if not exist, an instance will be created.
     *
     * @param group the group of MetricRegistry
     * @param name the name of the metric
     * @return an instance of meter,
     */
    Counter getCounter(String group, MetricName name);

    /**
     * Create a {@link Histogram} metric in given group, and name.
     * if not exist, an instance will be created.
     *
     * @param group the group of MetricRegistry
     * @param name the name of the metric
     * @return an instance of meter,
     */
    Histogram getHistogram(String group, MetricName name);

    /**
     * Create a {@link Timer} metric in given group, and name.
     * if not exist, an instance will be created.
     *
     * @param group the group of MetricRegistry
     * @param name the name of the metric
     * @return an instance of meter,
     */
    Timer getTimer(String group, MetricName name);


    /**
     * Register a customized metric to specified group.
     * @param group: the group name of MetricRegistry
     * @param metric the metric to register
     */
    void register(String group, MetricName name, Metric metric);

    /**
     * Get a list of group in current MetricManager
     * @return a list of group name
     */
    List<String> listMetricGroups();

    /**
     * A global flag to complete disable the metrics feature
     * @return true if it is enabled.
     */
    boolean isEnabled();

    /**
     * A global flag to complete disable the metrics feature
     */
    void setEnabled(boolean enabled);

    /**
     * list all metric names by group
     * @return a map of metric name set, keyed by group name
     */
    Map<String, Set<MetricName>> listMetricNamesByGroup();

    /**
     * Get metric registry by group name,
     * if not found, null will be returned
     * @param group the group name to query
     * @return the MetricRegistry that is correspondent to the group
     */
    MetricRegistry getMetricRegistryByGroup(String group);


    SortedMap<MetricName, Gauge> getGauges(String group, MetricFilter filter);

    SortedMap<MetricName, Counter> getCounters(String group, MetricFilter filter);

    SortedMap<MetricName, Histogram> getHistograms(String group, MetricFilter filter);

    SortedMap<MetricName, Meter> getMeters(String group, MetricFilter filter);

    SortedMap<MetricName, Timer> getTimers(String group, MetricFilter filter);
}
