/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.fix.FixClassTypeResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.typeresolution.ClassTypeResolver;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAliRule
extends AbstractJavaRule {
    private static final Map<String, Boolean> TYPE_RESOLVER_MAP = new ConcurrentHashMap<String, Boolean>(16);
    private static final String EMPTY_FILE_NAME = "n/a";
    private static final String DELIMITER = "-";

    public Object visit(ASTCompilationUnit node, Object data) {
        String sourceCodeFilename = ((RuleContext)data).getSourceCodeFilename();
        if (StringUtils.isBlank((CharSequence)sourceCodeFilename) || EMPTY_FILE_NAME.equals(sourceCodeFilename)) {
            this.resolveType(node, data);
            return super.visit(node, data);
        }
        String uniqueId = sourceCodeFilename + DELIMITER + node.hashCode();
        if (!TYPE_RESOLVER_MAP.containsKey(uniqueId)) {
            this.resolveType(node, data);
            TYPE_RESOLVER_MAP.put(uniqueId, true);
        }
        return super.visit(node, data);
    }

    public void setDescription(String description) {
        super.setDescription(I18nResources.getMessage(description));
    }

    public void setMessage(String message) {
        super.setMessage(I18nResources.getMessageWithExceptionHandled(message));
    }

    public void addViolationWithMessage(Object data, Node node, String message) {
        super.addViolationWithMessage(data, node, I18nResources.getMessageWithExceptionHandled(message));
    }

    public void addViolationWithMessage(Object data, Node node, String message, Object[] args) {
        super.addViolationWithMessage(data, node, String.format(I18nResources.getMessageWithExceptionHandled(message), args));
    }

    private void resolveType(ASTCompilationUnit node, Object data) {
        FixClassTypeResolver classTypeResolver = new FixClassTypeResolver(AbstractAliRule.class.getClassLoader());
        node.setClassTypeResolver((ClassTypeResolver)classTypeResolver);
        node.jjtAccept((JavaParserVisitor)classTypeResolver, data);
    }
}

