/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.constant;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.namelist.NameListConfig;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;

public class UndefineMagicConstantRule
extends AbstractAliRule {
    private static final List<String> LITERAL_WHITE_LIST = NameListConfig.NAME_LIST_SERVICE.getNameList(UndefineMagicConstantRule.class.getSimpleName(), "LITERAL_WHITE_LIST");
    private static final String XPATH = "//Literal/../../../../..[not(VariableInitializer)]";

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        ArrayList<ASTLiteral> currentLiterals = new ArrayList<ASTLiteral>();
        try {
            List parentNodes = node.findChildNodesWithXPath(XPATH);
            for (Node parentItem : parentNodes) {
                List literals = parentItem.findDescendantsOfType(ASTLiteral.class);
                for (ASTLiteral literal : literals) {
                    if (!this.inBlackList(literal) || currentLiterals.contains(literal)) continue;
                    currentLiterals.add(literal);
                    String imageReplace = StringUtils.replace((String)literal.getImage(), (String)"{", (String)"'{");
                    this.addViolationWithMessage(data, (Node)literal, "java.constant.UndefineMagicConstantRule.violation.msg", new Object[]{imageReplace});
                }
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return super.visit(node, data);
    }

    private boolean inBlackList(ASTLiteral literal) {
        String name = literal.getImage();
        int lineNum = literal.getBeginLine();
        if (name == null) {
            return false;
        }
        for (String whiteItem : LITERAL_WHITE_LIST) {
            if (!whiteItem.equals(name)) continue;
            return false;
        }
        ASTIfStatement ifStatement = (ASTIfStatement)literal.getFirstParentOfType(ASTIfStatement.class);
        if (ifStatement != null && lineNum == ifStatement.getBeginLine()) {
            ASTForStatement forStatement = (ASTForStatement)ifStatement.getFirstParentOfType(ASTForStatement.class);
            ASTWhileStatement whileStatement = (ASTWhileStatement)ifStatement.getFirstParentOfType(ASTWhileStatement.class);
            return forStatement == null && whileStatement == null;
        }
        ASTForStatement blackForStatement = (ASTForStatement)literal.getFirstParentOfType(ASTForStatement.class);
        if (blackForStatement != null && lineNum == blackForStatement.getBeginLine()) {
            return true;
        }
        ASTWhileStatement blackWhileStatement = (ASTWhileStatement)literal.getFirstParentOfType(ASTWhileStatement.class);
        return blackWhileStatement != null && lineNum == blackWhileStatement.getBeginLine();
    }
}

