/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.naming;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.apache.commons.lang3.StringUtils;

public class ExceptionClassShouldEndWithExceptionRule
extends AbstractAliRule {
    private static final String EXCEPTION_END_SUFFIX = "Exception";

    public Object visit(ASTExtendsList node, Object data) {
        boolean isExceptionViolation;
        ASTClassOrInterfaceType astClassOrInterfaceType = (ASTClassOrInterfaceType)node.getFirstChildOfType(ASTClassOrInterfaceType.class);
        if (astClassOrInterfaceType == null || !TypeHelper.isA((TypeNode)astClassOrInterfaceType, Throwable.class)) {
            return super.visit(node, data);
        }
        ASTClassOrInterfaceDeclaration astClassOrInterfaceDeclaration = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        boolean bl = isExceptionViolation = astClassOrInterfaceDeclaration != null && StringUtils.isNotEmpty((CharSequence)astClassOrInterfaceDeclaration.getImage()) && !astClassOrInterfaceDeclaration.getImage().endsWith(EXCEPTION_END_SUFFIX);
        if (isExceptionViolation) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)astClassOrInterfaceDeclaration, data, I18nResources.getMessage("java.naming.ExceptionClassShouldEndWithExceptionRule.violation.msg", astClassOrInterfaceDeclaration.getImage()));
        }
        return super.visit(node, data);
    }
}

