/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.set;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import org.jaxen.JaxenException;

public class DontModifyInForeachCircleRule
extends AbstractAliRule {
    private static final String ADD = ".add";
    private static final String REMOVE = ".remove";
    private static final String CLEAR = ".clear";
    private static final String XPATH = "//ForStatement/Expression/PrimaryExpression/PrimaryPrefix/Name";
    private static final String CHILD_XPATH = "Statement/Block/BlockStatement/Statement/StatementExpression/PrimaryExpression/PrimaryPrefix/Name";

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        try {
            List nodes = node.findChildNodesWithXPath(XPATH);
            for (Node item : nodes) {
                String variableName;
                if (!(item instanceof ASTName) || (variableName = item.getImage()) == null) continue;
                ASTForStatement forStatement = (ASTForStatement)item.getFirstParentOfType(ASTForStatement.class);
                List blockNodes = forStatement.findChildNodesWithXPath(CHILD_XPATH);
                for (Node blockItem : blockNodes) {
                    if (!(blockItem instanceof ASTName) || !this.judgeName(blockItem.getImage(), variableName)) continue;
                    this.addViolationWithMessage(data, blockItem, "java.set.DontModifyInForeachCircleRule.violation.msg", new Object[]{blockItem.getImage()});
                }
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return super.visit(node, data);
    }

    private boolean judgeName(String name, String variableName) {
        return name != null && (name.equals(variableName + ADD) || name.equals(variableName + REMOVE) || name.equals(variableName + CLEAR));
    }
}

