/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.msg;

import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.java_websocket.client.WebSocketClient;
import com.alipay.api.java_websocket.handshake.ServerHandshake;
import com.alipay.api.msg.AlipayMsgClient;
import java.net.URI;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgConnector
extends WebSocketClient {
    private AlipayMsgClient alipayMsgClient;

    public MsgConnector(URI serverUri, Map<String, String> httpHeaders, AlipayMsgClient alipayMsgClient, String charset) {
        super(serverUri, httpHeaders, charset);
        this.alipayMsgClient = alipayMsgClient;
    }

    @Override
    public void onOpen(ServerHandshake handshakedata) {
        AlipayLogger.logBizDebug("conn open");
    }

    @Override
    public void onMessage(String message) {
        this.alipayMsgClient.onMessage(message);
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        AlipayLogger.logBizDebug("conn close");
    }

    @Override
    public void onError(Exception ex) {
        AlipayLogger.logBizError(ex);
    }
}

