/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.dysmsapi20170525.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class TagResourcesRequest
extends Request {
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ProdCode")
    private String prodCode;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceId")
    private List<String> resourceId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="ResourceType")
    @Validation(required=true)
    private String resourceType;
    @Query
    @NameInMap(value="Tag")
    @Validation(required=true)
    private List<Tag> tag;

    private TagResourcesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.ownerId = builder.ownerId;
        this.prodCode = builder.prodCode;
        this.regionId = builder.regionId;
        this.resourceId = builder.resourceId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceType = builder.resourceType;
        this.tag = builder.tag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TagResourcesRequest create() {
        return TagResourcesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getProdCode() {
        return this.prodCode;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public List<String> getResourceId() {
        return this.resourceId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<TagResourcesRequest, Builder> {
        private Long ownerId;
        private String prodCode;
        private String regionId;
        private List<String> resourceId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String resourceType;
        private List<Tag> tag;

        private Builder() {
        }

        private Builder(TagResourcesRequest response) {
            super((Request)response);
            this.ownerId = response.ownerId;
            this.prodCode = response.prodCode;
            this.regionId = response.regionId;
            this.resourceId = response.resourceId;
            this.resourceOwnerAccount = response.resourceOwnerAccount;
            this.resourceOwnerId = response.resourceOwnerId;
            this.resourceType = response.resourceType;
            this.tag = response.tag;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder prodCode(String prodCode) {
            this.putQueryParameter("ProdCode", prodCode);
            this.prodCode = prodCode;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceId(List<String> resourceId) {
            this.putQueryParameter("ResourceId", resourceId);
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public TagResourcesRequest build() {
            return new TagResourcesRequest(this);
        }
    }
}

