/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchCreateVodPackagingAssetRequest
extends Request {
    @Query
    @NameInMap(value="Assets")
    private List<Assets> assets;
    @Query
    @NameInMap(value="GroupName")
    private String groupName;

    private BatchCreateVodPackagingAssetRequest(Builder builder) {
        super((Request.Builder)builder);
        this.assets = builder.assets;
        this.groupName = builder.groupName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchCreateVodPackagingAssetRequest create() {
        return BatchCreateVodPackagingAssetRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Assets> getAssets() {
        return this.assets;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static class Assets
    extends TeaModel {
        @NameInMap(value="AssetName")
        private String assetName;
        @NameInMap(value="ContentId")
        private String contentId;
        @NameInMap(value="Input")
        private Input input;

        private Assets(Builder builder) {
            this.assetName = builder.assetName;
            this.contentId = builder.contentId;
            this.input = builder.input;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Assets create() {
            return Assets.builder().build();
        }

        public String getAssetName() {
            return this.assetName;
        }

        public String getContentId() {
            return this.contentId;
        }

        public Input getInput() {
            return this.input;
        }

        public static final class Builder {
            private String assetName;
            private String contentId;
            private Input input;

            private Builder() {
            }

            private Builder(Assets model) {
                this.assetName = model.assetName;
                this.contentId = model.contentId;
                this.input = model.input;
            }

            public Builder assetName(String assetName) {
                this.assetName = assetName;
                return this;
            }

            public Builder contentId(String contentId) {
                this.contentId = contentId;
                return this;
            }

            public Builder input(Input input) {
                this.input = input;
                return this;
            }

            public Assets build() {
                return new Assets(this);
            }
        }
    }

    public static class Input
    extends TeaModel {
        @NameInMap(value="Media")
        private String media;
        @NameInMap(value="Type")
        private String type;

        private Input(Builder builder) {
            this.media = builder.media;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Input create() {
            return Input.builder().build();
        }

        public String getMedia() {
            return this.media;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String media;
            private String type;

            private Builder() {
            }

            private Builder(Input model) {
                this.media = model.media;
                this.type = model.type;
            }

            public Builder media(String media) {
                this.media = media;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Input build() {
                return new Input(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchCreateVodPackagingAssetRequest, Builder> {
        private List<Assets> assets;
        private String groupName;

        private Builder() {
        }

        private Builder(BatchCreateVodPackagingAssetRequest request) {
            super((Request)request);
            this.assets = request.assets;
            this.groupName = request.groupName;
        }

        public Builder assets(List<Assets> assets) {
            String assetsShrink = this.shrink(assets, "Assets", "json");
            this.putQueryParameter("Assets", assetsShrink);
            this.assets = assets;
            return this;
        }

        public Builder groupName(String groupName) {
            this.putQueryParameter("GroupName", groupName);
            this.groupName = groupName;
            return this;
        }

        public BatchCreateVodPackagingAssetRequest build() {
            return new BatchCreateVodPackagingAssetRequest(this);
        }
    }
}

