/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateAvatarTrainingJobRequest
extends Request {
    @Query
    @NameInMap(value="AvatarDescription")
    @Validation(maxLength=1027)
    private String avatarDescription;
    @Query
    @NameInMap(value="AvatarName")
    @Validation(required=true, maxLength=7)
    private String avatarName;
    @Query
    @NameInMap(value="AvatarType")
    private String avatarType;
    @Query
    @NameInMap(value="Portrait")
    @Validation(maxLength=32, minLength=32)
    private String portrait;
    @Query
    @NameInMap(value="Thumbnail")
    @Validation(maxLength=512)
    private String thumbnail;
    @Query
    @NameInMap(value="Transparent")
    private Boolean transparent;
    @Query
    @NameInMap(value="Video")
    @Validation(maxLength=32, minLength=32)
    private String video;

    private CreateAvatarTrainingJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.avatarDescription = builder.avatarDescription;
        this.avatarName = builder.avatarName;
        this.avatarType = builder.avatarType;
        this.portrait = builder.portrait;
        this.thumbnail = builder.thumbnail;
        this.transparent = builder.transparent;
        this.video = builder.video;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateAvatarTrainingJobRequest create() {
        return CreateAvatarTrainingJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAvatarDescription() {
        return this.avatarDescription;
    }

    public String getAvatarName() {
        return this.avatarName;
    }

    public String getAvatarType() {
        return this.avatarType;
    }

    public String getPortrait() {
        return this.portrait;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public Boolean getTransparent() {
        return this.transparent;
    }

    public String getVideo() {
        return this.video;
    }

    public static final class Builder
    extends Request.Builder<CreateAvatarTrainingJobRequest, Builder> {
        private String avatarDescription;
        private String avatarName;
        private String avatarType;
        private String portrait;
        private String thumbnail;
        private Boolean transparent;
        private String video;

        private Builder() {
        }

        private Builder(CreateAvatarTrainingJobRequest request) {
            super((Request)request);
            this.avatarDescription = request.avatarDescription;
            this.avatarName = request.avatarName;
            this.avatarType = request.avatarType;
            this.portrait = request.portrait;
            this.thumbnail = request.thumbnail;
            this.transparent = request.transparent;
            this.video = request.video;
        }

        public Builder avatarDescription(String avatarDescription) {
            this.putQueryParameter("AvatarDescription", avatarDescription);
            this.avatarDescription = avatarDescription;
            return this;
        }

        public Builder avatarName(String avatarName) {
            this.putQueryParameter("AvatarName", avatarName);
            this.avatarName = avatarName;
            return this;
        }

        public Builder avatarType(String avatarType) {
            this.putQueryParameter("AvatarType", avatarType);
            this.avatarType = avatarType;
            return this;
        }

        public Builder portrait(String portrait) {
            this.putQueryParameter("Portrait", portrait);
            this.portrait = portrait;
            return this;
        }

        public Builder thumbnail(String thumbnail) {
            this.putQueryParameter("Thumbnail", thumbnail);
            this.thumbnail = thumbnail;
            return this;
        }

        public Builder transparent(Boolean transparent) {
            this.putQueryParameter("Transparent", transparent);
            this.transparent = transparent;
            return this;
        }

        public Builder video(String video) {
            this.putQueryParameter("Video", video);
            this.video = video;
            return this;
        }

        public CreateAvatarTrainingJobRequest build() {
            return new CreateAvatarTrainingJobRequest(this);
        }
    }
}

