/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListAvatarsRequest
extends Request {
    @Query
    @NameInMap(value="AvatarType")
    private String avatarType;
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0)
    private Integer pageSize;

    private ListAvatarsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.avatarType = builder.avatarType;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListAvatarsRequest create() {
        return ListAvatarsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAvatarType() {
        return this.avatarType;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<ListAvatarsRequest, Builder> {
        private String avatarType;
        private Integer pageNo;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(ListAvatarsRequest request) {
            super((Request)request);
            this.avatarType = request.avatarType;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
        }

        public Builder avatarType(String avatarType) {
            this.putQueryParameter("AvatarType", avatarType);
            this.avatarType = avatarType;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListAvatarsRequest build() {
            return new ListAvatarsRequest(this);
        }
    }
}

