/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ListLiveSnapshotTemplatesRequest
extends Request {
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="SearchKeyWord")
    private String searchKeyWord;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;
    @Query
    @NameInMap(value="TemplateIds")
    private List<String> templateIds;
    @Query
    @NameInMap(value="Type")
    private String type;

    private ListLiveSnapshotTemplatesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.searchKeyWord = builder.searchKeyWord;
        this.sortBy = builder.sortBy;
        this.templateIds = builder.templateIds;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveSnapshotTemplatesRequest create() {
        return ListLiveSnapshotTemplatesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSearchKeyWord() {
        return this.searchKeyWord;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public List<String> getTemplateIds() {
        return this.templateIds;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<ListLiveSnapshotTemplatesRequest, Builder> {
        private Integer pageNo;
        private Integer pageSize;
        private String searchKeyWord;
        private String sortBy;
        private List<String> templateIds;
        private String type;

        private Builder() {
        }

        private Builder(ListLiveSnapshotTemplatesRequest request) {
            super((Request)request);
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.searchKeyWord = request.searchKeyWord;
            this.sortBy = request.sortBy;
            this.templateIds = request.templateIds;
            this.type = request.type;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder searchKeyWord(String searchKeyWord) {
            this.putQueryParameter("SearchKeyWord", searchKeyWord);
            this.searchKeyWord = searchKeyWord;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public Builder templateIds(List<String> templateIds) {
            this.putQueryParameter("TemplateIds", templateIds);
            this.templateIds = templateIds;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public ListLiveSnapshotTemplatesRequest build() {
            return new ListLiveSnapshotTemplatesRequest(this);
        }
    }
}

