/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListSmartJobsRequest
extends Request {
    @Query
    @NameInMap(value="JobState")
    private String jobState;
    @Query
    @NameInMap(value="JobType")
    private String jobType;
    @Query
    @NameInMap(value="MaxResults")
    private Long maxResults;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="PageNo")
    private Long pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;

    private ListSmartJobsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.jobState = builder.jobState;
        this.jobType = builder.jobType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListSmartJobsRequest create() {
        return ListSmartJobsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getJobState() {
        return this.jobState;
    }

    public String getJobType() {
        return this.jobType;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public Long getPageNo() {
        return this.pageNo;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public static final class Builder
    extends Request.Builder<ListSmartJobsRequest, Builder> {
        private String jobState;
        private String jobType;
        private Long maxResults;
        private String nextToken;
        private Long pageNo;
        private Long pageSize;
        private String sortBy;

        private Builder() {
        }

        private Builder(ListSmartJobsRequest request) {
            super((Request)request);
            this.jobState = request.jobState;
            this.jobType = request.jobType;
            this.maxResults = request.maxResults;
            this.nextToken = request.nextToken;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
        }

        public Builder jobState(String jobState) {
            this.putQueryParameter("JobState", jobState);
            this.jobState = jobState;
            return this;
        }

        public Builder jobType(String jobType) {
            this.putQueryParameter("JobType", jobType);
            this.jobType = jobType;
            return this;
        }

        public Builder maxResults(Long maxResults) {
            this.putQueryParameter("MaxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder pageNo(Long pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public ListSmartJobsRequest build() {
            return new ListSmartJobsRequest(this);
        }
    }
}

