/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListSystemTemplatesRequest
extends Request {
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="Status")
    private String status;
    @Query
    @NameInMap(value="Subtype")
    private String subtype;
    @Query
    @NameInMap(value="TemplateId")
    private String templateId;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private ListSystemTemplatesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.name = builder.name;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.status = builder.status;
        this.subtype = builder.subtype;
        this.templateId = builder.templateId;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListSystemTemplatesRequest create() {
        return ListSystemTemplatesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<ListSystemTemplatesRequest, Builder> {
        private String name;
        private Integer pageNumber;
        private Integer pageSize;
        private String status;
        private String subtype;
        private String templateId;
        private String type;

        private Builder() {
        }

        private Builder(ListSystemTemplatesRequest request) {
            super((Request)request);
            this.name = request.name;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.status = request.status;
            this.subtype = request.subtype;
            this.templateId = request.templateId;
            this.type = request.type;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public Builder subtype(String subtype) {
            this.putQueryParameter("Subtype", subtype);
            this.subtype = subtype;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putQueryParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public ListSystemTemplatesRequest build() {
            return new ListSystemTemplatesRequest(this);
        }
    }
}

