/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class QueryVideoCognitionJobRequest
extends Request {
    @Query
    @NameInMap(value="IncludeResults")
    private IncludeResults includeResults;
    @Query
    @NameInMap(value="JobId")
    @Validation(required=true)
    private String jobId;
    @Query
    @NameInMap(value="Params")
    private String params;

    private QueryVideoCognitionJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.includeResults = builder.includeResults;
        this.jobId = builder.jobId;
        this.params = builder.params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryVideoCognitionJobRequest create() {
        return QueryVideoCognitionJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public IncludeResults getIncludeResults() {
        return this.includeResults;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getParams() {
        return this.params;
    }

    public static class IncludeResults
    extends TeaModel {
        @NameInMap(value="NeedAsr")
        private Boolean needAsr;
        @NameInMap(value="NeedOcr")
        private Boolean needOcr;
        @NameInMap(value="NeedProcess")
        private Boolean needProcess;

        private IncludeResults(Builder builder) {
            this.needAsr = builder.needAsr;
            this.needOcr = builder.needOcr;
            this.needProcess = builder.needProcess;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static IncludeResults create() {
            return IncludeResults.builder().build();
        }

        public Boolean getNeedAsr() {
            return this.needAsr;
        }

        public Boolean getNeedOcr() {
            return this.needOcr;
        }

        public Boolean getNeedProcess() {
            return this.needProcess;
        }

        public static final class Builder {
            private Boolean needAsr;
            private Boolean needOcr;
            private Boolean needProcess;

            private Builder() {
            }

            private Builder(IncludeResults model) {
                this.needAsr = model.needAsr;
                this.needOcr = model.needOcr;
                this.needProcess = model.needProcess;
            }

            public Builder needAsr(Boolean needAsr) {
                this.needAsr = needAsr;
                return this;
            }

            public Builder needOcr(Boolean needOcr) {
                this.needOcr = needOcr;
                return this;
            }

            public Builder needProcess(Boolean needProcess) {
                this.needProcess = needProcess;
                return this;
            }

            public IncludeResults build() {
                return new IncludeResults(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<QueryVideoCognitionJobRequest, Builder> {
        private IncludeResults includeResults;
        private String jobId;
        private String params;

        private Builder() {
        }

        private Builder(QueryVideoCognitionJobRequest request) {
            super((Request)request);
            this.includeResults = request.includeResults;
            this.jobId = request.jobId;
            this.params = request.params;
        }

        public Builder includeResults(IncludeResults includeResults) {
            String includeResultsShrink = this.shrink((Object)includeResults, "IncludeResults", "json");
            this.putQueryParameter("IncludeResults", includeResultsShrink);
            this.includeResults = includeResults;
            return this;
        }

        public Builder jobId(String jobId) {
            this.putQueryParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder params(String params) {
            this.putQueryParameter("Params", params);
            this.params = params;
            return this;
        }

        public QueryVideoCognitionJobRequest build() {
            return new QueryVideoCognitionJobRequest(this);
        }
    }
}

