/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class SubmitIProductionJobRequest
extends Request {
    @Query
    @NameInMap(value="FunctionName")
    @Validation(required=true)
    private String functionName;
    @Query
    @NameInMap(value="Input")
    @Validation(required=true)
    private Input input;
    @Query
    @NameInMap(value="JobParams")
    private String jobParams;
    @Query
    @NameInMap(value="ModelId")
    private String modelId;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="Output")
    @Validation(required=true)
    private Output output;
    @Query
    @NameInMap(value="ScheduleConfig")
    private ScheduleConfig scheduleConfig;
    @Query
    @NameInMap(value="TemplateId")
    private String templateId;
    @Query
    @NameInMap(value="UserData")
    private String userData;

    private SubmitIProductionJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.functionName = builder.functionName;
        this.input = builder.input;
        this.jobParams = builder.jobParams;
        this.modelId = builder.modelId;
        this.name = builder.name;
        this.output = builder.output;
        this.scheduleConfig = builder.scheduleConfig;
        this.templateId = builder.templateId;
        this.userData = builder.userData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SubmitIProductionJobRequest create() {
        return SubmitIProductionJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Input getInput() {
        return this.input;
    }

    public String getJobParams() {
        return this.jobParams;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getName() {
        return this.name;
    }

    public Output getOutput() {
        return this.output;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getUserData() {
        return this.userData;
    }

    public static class ScheduleConfig
    extends TeaModel {
        @NameInMap(value="PipelineId")
        private String pipelineId;
        @NameInMap(value="Priority")
        private Integer priority;

        private ScheduleConfig(Builder builder) {
            this.pipelineId = builder.pipelineId;
            this.priority = builder.priority;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ScheduleConfig create() {
            return ScheduleConfig.builder().build();
        }

        public String getPipelineId() {
            return this.pipelineId;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public static final class Builder {
            private String pipelineId;
            private Integer priority;

            private Builder() {
            }

            private Builder(ScheduleConfig model) {
                this.pipelineId = model.pipelineId;
                this.priority = model.priority;
            }

            public Builder pipelineId(String pipelineId) {
                this.pipelineId = pipelineId;
                return this;
            }

            public Builder priority(Integer priority) {
                this.priority = priority;
                return this;
            }

            public ScheduleConfig build() {
                return new ScheduleConfig(this);
            }
        }
    }

    public static class Output
    extends TeaModel {
        @NameInMap(value="Biz")
        private String biz;
        @NameInMap(value="Media")
        @Validation(required=true)
        private String media;
        @NameInMap(value="OutputUrl")
        private String outputUrl;
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;

        private Output(Builder builder) {
            this.biz = builder.biz;
            this.media = builder.media;
            this.outputUrl = builder.outputUrl;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Output create() {
            return Output.builder().build();
        }

        public String getBiz() {
            return this.biz;
        }

        public String getMedia() {
            return this.media;
        }

        public String getOutputUrl() {
            return this.outputUrl;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String biz;
            private String media;
            private String outputUrl;
            private String type;

            private Builder() {
            }

            private Builder(Output model) {
                this.biz = model.biz;
                this.media = model.media;
                this.outputUrl = model.outputUrl;
                this.type = model.type;
            }

            public Builder biz(String biz) {
                this.biz = biz;
                return this;
            }

            public Builder media(String media) {
                this.media = media;
                return this;
            }

            public Builder outputUrl(String outputUrl) {
                this.outputUrl = outputUrl;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Output build() {
                return new Output(this);
            }
        }
    }

    public static class Input
    extends TeaModel {
        @NameInMap(value="Media")
        @Validation(required=true)
        private String media;
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;

        private Input(Builder builder) {
            this.media = builder.media;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Input create() {
            return Input.builder().build();
        }

        public String getMedia() {
            return this.media;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String media;
            private String type;

            private Builder() {
            }

            private Builder(Input model) {
                this.media = model.media;
                this.type = model.type;
            }

            public Builder media(String media) {
                this.media = media;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Input build() {
                return new Input(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<SubmitIProductionJobRequest, Builder> {
        private String functionName;
        private Input input;
        private String jobParams;
        private String modelId;
        private String name;
        private Output output;
        private ScheduleConfig scheduleConfig;
        private String templateId;
        private String userData;

        private Builder() {
        }

        private Builder(SubmitIProductionJobRequest request) {
            super((Request)request);
            this.functionName = request.functionName;
            this.input = request.input;
            this.jobParams = request.jobParams;
            this.modelId = request.modelId;
            this.name = request.name;
            this.output = request.output;
            this.scheduleConfig = request.scheduleConfig;
            this.templateId = request.templateId;
            this.userData = request.userData;
        }

        public Builder functionName(String functionName) {
            this.putQueryParameter("FunctionName", functionName);
            this.functionName = functionName;
            return this;
        }

        public Builder input(Input input) {
            String inputShrink = this.shrink((Object)input, "Input", "json");
            this.putQueryParameter("Input", inputShrink);
            this.input = input;
            return this;
        }

        public Builder jobParams(String jobParams) {
            this.putQueryParameter("JobParams", jobParams);
            this.jobParams = jobParams;
            return this;
        }

        public Builder modelId(String modelId) {
            this.putQueryParameter("ModelId", modelId);
            this.modelId = modelId;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder output(Output output) {
            String outputShrink = this.shrink((Object)output, "Output", "json");
            this.putQueryParameter("Output", outputShrink);
            this.output = output;
            return this;
        }

        public Builder scheduleConfig(ScheduleConfig scheduleConfig) {
            String scheduleConfigShrink = this.shrink((Object)scheduleConfig, "ScheduleConfig", "json");
            this.putQueryParameter("ScheduleConfig", scheduleConfigShrink);
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putQueryParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public SubmitIProductionJobRequest build() {
            return new SubmitIProductionJobRequest(this);
        }
    }
}

