/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class SubmitLiveRecordJobRequest
extends Request {
    @Body
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Body
    @NameInMap(value="NotifyUrl")
    private String notifyUrl;
    @Body
    @NameInMap(value="RecordOutput")
    @Validation(required=true)
    private RecordOutput recordOutput;
    @Body
    @NameInMap(value="StreamInput")
    @Validation(required=true)
    private StreamInput streamInput;
    @Body
    @NameInMap(value="TemplateId")
    @Validation(required=true)
    private String templateId;

    private SubmitLiveRecordJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.name = builder.name;
        this.notifyUrl = builder.notifyUrl;
        this.recordOutput = builder.recordOutput;
        this.streamInput = builder.streamInput;
        this.templateId = builder.templateId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SubmitLiveRecordJobRequest create() {
        return SubmitLiveRecordJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public RecordOutput getRecordOutput() {
        return this.recordOutput;
    }

    public StreamInput getStreamInput() {
        return this.streamInput;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public static class StreamInput
    extends TeaModel {
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;
        @NameInMap(value="Url")
        private String url;

        private StreamInput(Builder builder) {
            this.type = builder.type;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static StreamInput create() {
            return StreamInput.builder().build();
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private String type;
            private String url;

            private Builder() {
            }

            private Builder(StreamInput model) {
                this.type = model.type;
                this.url = model.url;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public StreamInput build() {
                return new StreamInput(this);
            }
        }
    }

    public static class RecordOutput
    extends TeaModel {
        @NameInMap(value="Bucket")
        private String bucket;
        @NameInMap(value="Endpoint")
        private String endpoint;
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;

        private RecordOutput(Builder builder) {
            this.bucket = builder.bucket;
            this.endpoint = builder.endpoint;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RecordOutput create() {
            return RecordOutput.builder().build();
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String bucket;
            private String endpoint;
            private String type;

            private Builder() {
            }

            private Builder(RecordOutput model) {
                this.bucket = model.bucket;
                this.endpoint = model.endpoint;
                this.type = model.type;
            }

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public RecordOutput build() {
                return new RecordOutput(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<SubmitLiveRecordJobRequest, Builder> {
        private String name;
        private String notifyUrl;
        private RecordOutput recordOutput;
        private StreamInput streamInput;
        private String templateId;

        private Builder() {
        }

        private Builder(SubmitLiveRecordJobRequest request) {
            super((Request)request);
            this.name = request.name;
            this.notifyUrl = request.notifyUrl;
            this.recordOutput = request.recordOutput;
            this.streamInput = request.streamInput;
            this.templateId = request.templateId;
        }

        public Builder name(String name) {
            this.putBodyParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder notifyUrl(String notifyUrl) {
            this.putBodyParameter("NotifyUrl", notifyUrl);
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Builder recordOutput(RecordOutput recordOutput) {
            String recordOutputShrink = this.shrink((Object)recordOutput, "RecordOutput", "json");
            this.putBodyParameter("RecordOutput", recordOutputShrink);
            this.recordOutput = recordOutput;
            return this;
        }

        public Builder streamInput(StreamInput streamInput) {
            String streamInputShrink = this.shrink((Object)streamInput, "StreamInput", "json");
            this.putBodyParameter("StreamInput", streamInputShrink);
            this.streamInput = streamInput;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putBodyParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public SubmitLiveRecordJobRequest build() {
            return new SubmitLiveRecordJobRequest(this);
        }
    }
}

