/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class SubmitLiveSnapshotJobRequest
extends Request {
    @Body
    @NameInMap(value="CallbackUrl")
    private String callbackUrl;
    @Body
    @NameInMap(value="JobName")
    @Validation(required=true)
    private String jobName;
    @Body
    @NameInMap(value="SnapshotOutput")
    @Validation(required=true)
    private SnapshotOutput snapshotOutput;
    @Body
    @NameInMap(value="StreamInput")
    @Validation(required=true)
    private StreamInput streamInput;
    @Body
    @NameInMap(value="TemplateId")
    @Validation(required=true)
    private String templateId;

    private SubmitLiveSnapshotJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.callbackUrl = builder.callbackUrl;
        this.jobName = builder.jobName;
        this.snapshotOutput = builder.snapshotOutput;
        this.streamInput = builder.streamInput;
        this.templateId = builder.templateId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SubmitLiveSnapshotJobRequest create() {
        return SubmitLiveSnapshotJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getJobName() {
        return this.jobName;
    }

    public SnapshotOutput getSnapshotOutput() {
        return this.snapshotOutput;
    }

    public StreamInput getStreamInput() {
        return this.streamInput;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public static class StreamInput
    extends TeaModel {
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;
        @NameInMap(value="Url")
        @Validation(required=true)
        private String url;

        private StreamInput(Builder builder) {
            this.type = builder.type;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static StreamInput create() {
            return StreamInput.builder().build();
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private String type;
            private String url;

            private Builder() {
            }

            private Builder(StreamInput model) {
                this.type = model.type;
                this.url = model.url;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public StreamInput build() {
                return new StreamInput(this);
            }
        }
    }

    public static class SnapshotOutput
    extends TeaModel {
        @NameInMap(value="Bucket")
        @Validation(required=true)
        private String bucket;
        @NameInMap(value="Endpoint")
        @Validation(required=true)
        private String endpoint;
        @NameInMap(value="StorageType")
        @Validation(required=true)
        private String storageType;

        private SnapshotOutput(Builder builder) {
            this.bucket = builder.bucket;
            this.endpoint = builder.endpoint;
            this.storageType = builder.storageType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SnapshotOutput create() {
            return SnapshotOutput.builder().build();
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public static final class Builder {
            private String bucket;
            private String endpoint;
            private String storageType;

            private Builder() {
            }

            private Builder(SnapshotOutput model) {
                this.bucket = model.bucket;
                this.endpoint = model.endpoint;
                this.storageType = model.storageType;
            }

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder storageType(String storageType) {
                this.storageType = storageType;
                return this;
            }

            public SnapshotOutput build() {
                return new SnapshotOutput(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<SubmitLiveSnapshotJobRequest, Builder> {
        private String callbackUrl;
        private String jobName;
        private SnapshotOutput snapshotOutput;
        private StreamInput streamInput;
        private String templateId;

        private Builder() {
        }

        private Builder(SubmitLiveSnapshotJobRequest request) {
            super((Request)request);
            this.callbackUrl = request.callbackUrl;
            this.jobName = request.jobName;
            this.snapshotOutput = request.snapshotOutput;
            this.streamInput = request.streamInput;
            this.templateId = request.templateId;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.putBodyParameter("CallbackUrl", callbackUrl);
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder jobName(String jobName) {
            this.putBodyParameter("JobName", jobName);
            this.jobName = jobName;
            return this;
        }

        public Builder snapshotOutput(SnapshotOutput snapshotOutput) {
            String snapshotOutputShrink = this.shrink((Object)snapshotOutput, "SnapshotOutput", "json");
            this.putBodyParameter("SnapshotOutput", snapshotOutputShrink);
            this.snapshotOutput = snapshotOutput;
            return this;
        }

        public Builder streamInput(StreamInput streamInput) {
            String streamInputShrink = this.shrink((Object)streamInput, "StreamInput", "json");
            this.putBodyParameter("StreamInput", streamInputShrink);
            this.streamInput = streamInput;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putBodyParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public SubmitLiveSnapshotJobRequest build() {
            return new SubmitLiveSnapshotJobRequest(this);
        }
    }
}

