/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class SubmitPackageJobRequest
extends Request {
    @Query
    @NameInMap(value="Inputs")
    @Validation(required=true)
    private List<Inputs> inputs;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="Output")
    @Validation(required=true)
    private Output output;
    @Query
    @NameInMap(value="ScheduleConfig")
    private ScheduleConfig scheduleConfig;
    @Query
    @NameInMap(value="UserData")
    private String userData;

    private SubmitPackageJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.inputs = builder.inputs;
        this.name = builder.name;
        this.output = builder.output;
        this.scheduleConfig = builder.scheduleConfig;
        this.userData = builder.userData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SubmitPackageJobRequest create() {
        return SubmitPackageJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Inputs> getInputs() {
        return this.inputs;
    }

    public String getName() {
        return this.name;
    }

    public Output getOutput() {
        return this.output;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public String getUserData() {
        return this.userData;
    }

    public static class ScheduleConfig
    extends TeaModel {
        @NameInMap(value="PipelineId")
        private String pipelineId;
        @NameInMap(value="Priority")
        private Integer priority;

        private ScheduleConfig(Builder builder) {
            this.pipelineId = builder.pipelineId;
            this.priority = builder.priority;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ScheduleConfig create() {
            return ScheduleConfig.builder().build();
        }

        public String getPipelineId() {
            return this.pipelineId;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public static final class Builder {
            private String pipelineId;
            private Integer priority;

            private Builder() {
            }

            private Builder(ScheduleConfig model) {
                this.pipelineId = model.pipelineId;
                this.priority = model.priority;
            }

            public Builder pipelineId(String pipelineId) {
                this.pipelineId = pipelineId;
                return this;
            }

            public Builder priority(Integer priority) {
                this.priority = priority;
                return this;
            }

            public ScheduleConfig build() {
                return new ScheduleConfig(this);
            }
        }
    }

    public static class Output
    extends TeaModel {
        @NameInMap(value="Media")
        @Validation(required=true)
        private String media;
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;

        private Output(Builder builder) {
            this.media = builder.media;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Output create() {
            return Output.builder().build();
        }

        public String getMedia() {
            return this.media;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String media;
            private String type;

            private Builder() {
            }

            private Builder(Output model) {
                this.media = model.media;
                this.type = model.type;
            }

            public Builder media(String media) {
                this.media = media;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Output build() {
                return new Output(this);
            }
        }
    }

    public static class Inputs
    extends TeaModel {
        @NameInMap(value="Input")
        @Validation(required=true)
        private Input input;

        private Inputs(Builder builder) {
            this.input = builder.input;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Inputs create() {
            return Inputs.builder().build();
        }

        public Input getInput() {
            return this.input;
        }

        public static final class Builder {
            private Input input;

            private Builder() {
            }

            private Builder(Inputs model) {
                this.input = model.input;
            }

            public Builder input(Input input) {
                this.input = input;
                return this;
            }

            public Inputs build() {
                return new Inputs(this);
            }
        }
    }

    public static class Input
    extends TeaModel {
        @NameInMap(value="Media")
        @Validation(required=true)
        private String media;
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;

        private Input(Builder builder) {
            this.media = builder.media;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Input create() {
            return Input.builder().build();
        }

        public String getMedia() {
            return this.media;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String media;
            private String type;

            private Builder() {
            }

            private Builder(Input model) {
                this.media = model.media;
                this.type = model.type;
            }

            public Builder media(String media) {
                this.media = media;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Input build() {
                return new Input(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<SubmitPackageJobRequest, Builder> {
        private List<Inputs> inputs;
        private String name;
        private Output output;
        private ScheduleConfig scheduleConfig;
        private String userData;

        private Builder() {
        }

        private Builder(SubmitPackageJobRequest request) {
            super((Request)request);
            this.inputs = request.inputs;
            this.name = request.name;
            this.output = request.output;
            this.scheduleConfig = request.scheduleConfig;
            this.userData = request.userData;
        }

        public Builder inputs(List<Inputs> inputs) {
            String inputsShrink = this.shrink(inputs, "Inputs", "json");
            this.putQueryParameter("Inputs", inputsShrink);
            this.inputs = inputs;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder output(Output output) {
            String outputShrink = this.shrink((Object)output, "Output", "json");
            this.putQueryParameter("Output", outputShrink);
            this.output = output;
            return this;
        }

        public Builder scheduleConfig(ScheduleConfig scheduleConfig) {
            String scheduleConfigShrink = this.shrink((Object)scheduleConfig, "ScheduleConfig", "json");
            this.putQueryParameter("ScheduleConfig", scheduleConfigShrink);
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public SubmitPackageJobRequest build() {
            return new SubmitPackageJobRequest(this);
        }
    }
}

