/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.ice20201109.models.AIAgentConfig;
import com.aliyun.sdk.service.ice20201109.models.AIAgentTemplateConfig;

public class UpdateAIAgentInstanceRequest
extends Request {
    @Query
    @NameInMap(value="AgentConfig")
    private AIAgentConfig agentConfig;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="TemplateConfig")
    @Deprecated
    private AIAgentTemplateConfig templateConfig;
    @Query
    @NameInMap(value="UserData")
    private String userData;

    private UpdateAIAgentInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.agentConfig = builder.agentConfig;
        this.instanceId = builder.instanceId;
        this.templateConfig = builder.templateConfig;
        this.userData = builder.userData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateAIAgentInstanceRequest create() {
        return UpdateAIAgentInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public AIAgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public AIAgentTemplateConfig getTemplateConfig() {
        return this.templateConfig;
    }

    public String getUserData() {
        return this.userData;
    }

    public static final class Builder
    extends Request.Builder<UpdateAIAgentInstanceRequest, Builder> {
        private AIAgentConfig agentConfig;
        private String instanceId;
        private AIAgentTemplateConfig templateConfig;
        private String userData;

        private Builder() {
        }

        private Builder(UpdateAIAgentInstanceRequest request) {
            super((Request)request);
            this.agentConfig = request.agentConfig;
            this.instanceId = request.instanceId;
            this.templateConfig = request.templateConfig;
            this.userData = request.userData;
        }

        public Builder agentConfig(AIAgentConfig agentConfig) {
            String agentConfigShrink = this.shrink((Object)agentConfig, "AgentConfig", "json");
            this.putQueryParameter("AgentConfig", agentConfigShrink);
            this.agentConfig = agentConfig;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder templateConfig(AIAgentTemplateConfig templateConfig) {
            String templateConfigShrink = this.shrink((Object)templateConfig, "TemplateConfig", "json");
            this.putQueryParameter("TemplateConfig", templateConfigShrink);
            this.templateConfig = templateConfig;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public UpdateAIAgentInstanceRequest build() {
            return new UpdateAIAgentInstanceRequest(this);
        }
    }
}

