/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateChannelRequest
extends Request {
    @Query
    @NameInMap(value="AccessPolicy")
    private Boolean accessPolicy;
    @Query
    @NameInMap(value="AccessToken")
    private String accessToken;
    @Query
    @NameInMap(value="ChannelName")
    @Validation(required=true)
    private String channelName;
    @Query
    @NameInMap(value="FillerSourceLocationName")
    private String fillerSourceLocationName;
    @Query
    @NameInMap(value="FillerSourceName")
    private String fillerSourceName;
    @Query
    @NameInMap(value="OutPutConfigList")
    @Validation(required=true)
    private String outPutConfigList;

    private UpdateChannelRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessPolicy = builder.accessPolicy;
        this.accessToken = builder.accessToken;
        this.channelName = builder.channelName;
        this.fillerSourceLocationName = builder.fillerSourceLocationName;
        this.fillerSourceName = builder.fillerSourceName;
        this.outPutConfigList = builder.outPutConfigList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateChannelRequest create() {
        return UpdateChannelRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getAccessPolicy() {
        return this.accessPolicy;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getFillerSourceLocationName() {
        return this.fillerSourceLocationName;
    }

    public String getFillerSourceName() {
        return this.fillerSourceName;
    }

    public String getOutPutConfigList() {
        return this.outPutConfigList;
    }

    public static final class Builder
    extends Request.Builder<UpdateChannelRequest, Builder> {
        private Boolean accessPolicy;
        private String accessToken;
        private String channelName;
        private String fillerSourceLocationName;
        private String fillerSourceName;
        private String outPutConfigList;

        private Builder() {
        }

        private Builder(UpdateChannelRequest request) {
            super((Request)request);
            this.accessPolicy = request.accessPolicy;
            this.accessToken = request.accessToken;
            this.channelName = request.channelName;
            this.fillerSourceLocationName = request.fillerSourceLocationName;
            this.fillerSourceName = request.fillerSourceName;
            this.outPutConfigList = request.outPutConfigList;
        }

        public Builder accessPolicy(Boolean accessPolicy) {
            this.putQueryParameter("AccessPolicy", accessPolicy);
            this.accessPolicy = accessPolicy;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("AccessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder channelName(String channelName) {
            this.putQueryParameter("ChannelName", channelName);
            this.channelName = channelName;
            return this;
        }

        public Builder fillerSourceLocationName(String fillerSourceLocationName) {
            this.putQueryParameter("FillerSourceLocationName", fillerSourceLocationName);
            this.fillerSourceLocationName = fillerSourceLocationName;
            return this;
        }

        public Builder fillerSourceName(String fillerSourceName) {
            this.putQueryParameter("FillerSourceName", fillerSourceName);
            this.fillerSourceName = fillerSourceName;
            return this;
        }

        public Builder outPutConfigList(String outPutConfigList) {
            this.putQueryParameter("OutPutConfigList", outPutConfigList);
            this.outPutConfigList = outPutConfigList;
            return this;
        }

        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }
    }
}

