/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class BatchAddDataForApiSourceRequest
extends Request {
    @Query
    @NameInMap(value="ApiId")
    @Validation(required=true)
    private String apiId;
    @Query
    @NameInMap(value="ContentList")
    @Validation(required=true)
    private Map<String, ?> contentList;
    @Query
    @NameInMap(value="IotInstanceId")
    @Validation(required=true)
    private String iotInstanceId;

    private BatchAddDataForApiSourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.apiId = builder.apiId;
        this.contentList = builder.contentList;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchAddDataForApiSourceRequest create() {
        return BatchAddDataForApiSourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getApiId() {
        return this.apiId;
    }

    public Map<String, ?> getContentList() {
        return this.contentList;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static final class Builder
    extends Request.Builder<BatchAddDataForApiSourceRequest, Builder> {
        private String apiId;
        private Map<String, ?> contentList;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(BatchAddDataForApiSourceRequest request) {
            super((Request)request);
            this.apiId = request.apiId;
            this.contentList = request.contentList;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder apiId(String apiId) {
            this.putQueryParameter("ApiId", apiId);
            this.apiId = apiId;
            return this;
        }

        public Builder contentList(Map<String, ?> contentList) {
            String contentListShrink = this.shrink(contentList, "ContentList", "json");
            this.putQueryParameter("ContentList", contentListShrink);
            this.contentList = contentList;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public BatchAddDataForApiSourceRequest build() {
            return new BatchAddDataForApiSourceRequest(this);
        }
    }
}

