/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchAddThingTopoRequest
extends Request {
    @Query
    @NameInMap(value="GwDeviceName")
    @Validation(required=true)
    private String gwDeviceName;
    @Query
    @NameInMap(value="GwProductKey")
    @Validation(required=true)
    private String gwProductKey;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="TopoAddItem")
    @Validation(required=true)
    private List<TopoAddItem> topoAddItem;

    private BatchAddThingTopoRequest(Builder builder) {
        super((Request.Builder)builder);
        this.gwDeviceName = builder.gwDeviceName;
        this.gwProductKey = builder.gwProductKey;
        this.iotInstanceId = builder.iotInstanceId;
        this.topoAddItem = builder.topoAddItem;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchAddThingTopoRequest create() {
        return BatchAddThingTopoRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getGwDeviceName() {
        return this.gwDeviceName;
    }

    public String getGwProductKey() {
        return this.gwProductKey;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public List<TopoAddItem> getTopoAddItem() {
        return this.topoAddItem;
    }

    public static class TopoAddItem
    extends TeaModel {
        @NameInMap(value="ClientId")
        private String clientId;
        @NameInMap(value="DeviceName")
        @Validation(required=true)
        private String deviceName;
        @NameInMap(value="ProductKey")
        @Validation(required=true)
        private String productKey;
        @NameInMap(value="Sign")
        @Validation(required=true)
        private String sign;
        @NameInMap(value="SignMethod")
        @Validation(required=true)
        private String signMethod;
        @NameInMap(value="Timestamp")
        private String timestamp;

        private TopoAddItem(Builder builder) {
            this.clientId = builder.clientId;
            this.deviceName = builder.deviceName;
            this.productKey = builder.productKey;
            this.sign = builder.sign;
            this.signMethod = builder.signMethod;
            this.timestamp = builder.timestamp;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TopoAddItem create() {
            return TopoAddItem.builder().build();
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getProductKey() {
            return this.productKey;
        }

        public String getSign() {
            return this.sign;
        }

        public String getSignMethod() {
            return this.signMethod;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public static final class Builder {
            private String clientId;
            private String deviceName;
            private String productKey;
            private String sign;
            private String signMethod;
            private String timestamp;

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder productKey(String productKey) {
                this.productKey = productKey;
                return this;
            }

            public Builder sign(String sign) {
                this.sign = sign;
                return this;
            }

            public Builder signMethod(String signMethod) {
                this.signMethod = signMethod;
                return this;
            }

            public Builder timestamp(String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public TopoAddItem build() {
                return new TopoAddItem(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchAddThingTopoRequest, Builder> {
        private String gwDeviceName;
        private String gwProductKey;
        private String iotInstanceId;
        private List<TopoAddItem> topoAddItem;

        private Builder() {
        }

        private Builder(BatchAddThingTopoRequest request) {
            super((Request)request);
            this.gwDeviceName = request.gwDeviceName;
            this.gwProductKey = request.gwProductKey;
            this.iotInstanceId = request.iotInstanceId;
            this.topoAddItem = request.topoAddItem;
        }

        public Builder gwDeviceName(String gwDeviceName) {
            this.putQueryParameter("GwDeviceName", gwDeviceName);
            this.gwDeviceName = gwDeviceName;
            return this;
        }

        public Builder gwProductKey(String gwProductKey) {
            this.putQueryParameter("GwProductKey", gwProductKey);
            this.gwProductKey = gwProductKey;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder topoAddItem(List<TopoAddItem> topoAddItem) {
            this.putQueryParameter("TopoAddItem", topoAddItem);
            this.topoAddItem = topoAddItem;
            return this;
        }

        public BatchAddThingTopoRequest build() {
            return new BatchAddThingTopoRequest(this);
        }
    }
}

