/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchCheckVehicleDeviceRequest
extends Request {
    @Query
    @NameInMap(value="DeviceList")
    @Validation(required=true)
    private List<DeviceList> deviceList;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private BatchCheckVehicleDeviceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceList = builder.deviceList;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchCheckVehicleDeviceRequest create() {
        return BatchCheckVehicleDeviceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<DeviceList> getDeviceList() {
        return this.deviceList;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static class DeviceList
    extends TeaModel {
        @NameInMap(value="DeviceId")
        private String deviceId;
        @NameInMap(value="DeviceModel")
        @Validation(required=true)
        private String deviceModel;
        @NameInMap(value="Manufacturer")
        @Validation(required=true)
        private String manufacturer;

        private DeviceList(Builder builder) {
            this.deviceId = builder.deviceId;
            this.deviceModel = builder.deviceModel;
            this.manufacturer = builder.manufacturer;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DeviceList create() {
            return DeviceList.builder().build();
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public String getDeviceModel() {
            return this.deviceModel;
        }

        public String getManufacturer() {
            return this.manufacturer;
        }

        public static final class Builder {
            private String deviceId;
            private String deviceModel;
            private String manufacturer;

            public Builder deviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public Builder deviceModel(String deviceModel) {
                this.deviceModel = deviceModel;
                return this;
            }

            public Builder manufacturer(String manufacturer) {
                this.manufacturer = manufacturer;
                return this;
            }

            public DeviceList build() {
                return new DeviceList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchCheckVehicleDeviceRequest, Builder> {
        private List<DeviceList> deviceList;
        private String iotInstanceId;
        private String productKey;

        private Builder() {
        }

        private Builder(BatchCheckVehicleDeviceRequest request) {
            super((Request)request);
            this.deviceList = request.deviceList;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
        }

        public Builder deviceList(List<DeviceList> deviceList) {
            this.putQueryParameter("DeviceList", deviceList);
            this.deviceList = deviceList;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public BatchCheckVehicleDeviceRequest build() {
            return new BatchCheckVehicleDeviceRequest(this);
        }
    }
}

