/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchSetEdgeInstanceDeviceConfigRequest
extends Request {
    @Query
    @NameInMap(value="DeviceConfigs")
    @Validation(required=true)
    private List<DeviceConfigs> deviceConfigs;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private BatchSetEdgeInstanceDeviceConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceConfigs = builder.deviceConfigs;
        this.instanceId = builder.instanceId;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchSetEdgeInstanceDeviceConfigRequest create() {
        return BatchSetEdgeInstanceDeviceConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<DeviceConfigs> getDeviceConfigs() {
        return this.deviceConfigs;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static class DeviceConfigs
    extends TeaModel {
        @NameInMap(value="Content")
        @Validation(required=true)
        private String content;
        @NameInMap(value="IotId")
        @Validation(required=true)
        private String iotId;

        private DeviceConfigs(Builder builder) {
            this.content = builder.content;
            this.iotId = builder.iotId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DeviceConfigs create() {
            return DeviceConfigs.builder().build();
        }

        public String getContent() {
            return this.content;
        }

        public String getIotId() {
            return this.iotId;
        }

        public static final class Builder {
            private String content;
            private String iotId;

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder iotId(String iotId) {
                this.iotId = iotId;
                return this;
            }

            public DeviceConfigs build() {
                return new DeviceConfigs(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchSetEdgeInstanceDeviceConfigRequest, Builder> {
        private List<DeviceConfigs> deviceConfigs;
        private String instanceId;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(BatchSetEdgeInstanceDeviceConfigRequest request) {
            super((Request)request);
            this.deviceConfigs = request.deviceConfigs;
            this.instanceId = request.instanceId;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder deviceConfigs(List<DeviceConfigs> deviceConfigs) {
            this.putQueryParameter("DeviceConfigs", deviceConfigs);
            this.deviceConfigs = deviceConfigs;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public BatchSetEdgeInstanceDeviceConfigRequest build() {
            return new BatchSetEdgeInstanceDeviceConfigRequest(this);
        }
    }
}

