/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchUnbindProjectDevicesRequest
extends Request {
    @Body
    @NameInMap(value="Devices")
    @Validation(required=true)
    private List<Devices> devices;
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="ProjectId")
    @Validation(required=true)
    private String projectId;

    private BatchUnbindProjectDevicesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.devices = builder.devices;
        this.iotInstanceId = builder.iotInstanceId;
        this.projectId = builder.projectId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchUnbindProjectDevicesRequest create() {
        return BatchUnbindProjectDevicesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Devices> getDevices() {
        return this.devices;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public static class Devices
    extends TeaModel {
        @NameInMap(value="DeviceName")
        @Validation(required=true)
        private String deviceName;
        @NameInMap(value="ProductKey")
        @Validation(required=true)
        private String productKey;

        private Devices(Builder builder) {
            this.deviceName = builder.deviceName;
            this.productKey = builder.productKey;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Devices create() {
            return Devices.builder().build();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getProductKey() {
            return this.productKey;
        }

        public static final class Builder {
            private String deviceName;
            private String productKey;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder productKey(String productKey) {
                this.productKey = productKey;
                return this;
            }

            public Devices build() {
                return new Devices(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchUnbindProjectDevicesRequest, Builder> {
        private List<Devices> devices;
        private String iotInstanceId;
        private String projectId;

        private Builder() {
        }

        private Builder(BatchUnbindProjectDevicesRequest request) {
            super((Request)request);
            this.devices = request.devices;
            this.iotInstanceId = request.iotInstanceId;
            this.projectId = request.projectId;
        }

        public Builder devices(List<Devices> devices) {
            this.putBodyParameter("Devices", devices);
            this.devices = devices;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder projectId(String projectId) {
            this.putBodyParameter("ProjectId", projectId);
            this.projectId = projectId;
            return this;
        }

        public BatchUnbindProjectDevicesRequest build() {
            return new BatchUnbindProjectDevicesRequest(this);
        }
    }
}

