/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CopyThingModelRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="SourceModelVersion")
    private String sourceModelVersion;
    @Query
    @NameInMap(value="SourceProductKey")
    @Validation(required=true)
    private String sourceProductKey;
    @Query
    @NameInMap(value="TargetProductKey")
    @Validation(required=true)
    private String targetProductKey;

    private CopyThingModelRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.resourceGroupId = builder.resourceGroupId;
        this.sourceModelVersion = builder.sourceModelVersion;
        this.sourceProductKey = builder.sourceProductKey;
        this.targetProductKey = builder.targetProductKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CopyThingModelRequest create() {
        return CopyThingModelRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getSourceModelVersion() {
        return this.sourceModelVersion;
    }

    public String getSourceProductKey() {
        return this.sourceProductKey;
    }

    public String getTargetProductKey() {
        return this.targetProductKey;
    }

    public static final class Builder
    extends Request.Builder<CopyThingModelRequest, Builder> {
        private String iotInstanceId;
        private String resourceGroupId;
        private String sourceModelVersion;
        private String sourceProductKey;
        private String targetProductKey;

        private Builder() {
        }

        private Builder(CopyThingModelRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.resourceGroupId = request.resourceGroupId;
            this.sourceModelVersion = request.sourceModelVersion;
            this.sourceProductKey = request.sourceProductKey;
            this.targetProductKey = request.targetProductKey;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder sourceModelVersion(String sourceModelVersion) {
            this.putQueryParameter("SourceModelVersion", sourceModelVersion);
            this.sourceModelVersion = sourceModelVersion;
            return this;
        }

        public Builder sourceProductKey(String sourceProductKey) {
            this.putQueryParameter("SourceProductKey", sourceProductKey);
            this.sourceProductKey = sourceProductKey;
            return this;
        }

        public Builder targetProductKey(String targetProductKey) {
            this.putQueryParameter("TargetProductKey", targetProductKey);
            this.targetProductKey = targetProductKey;
            return this;
        }

        public CopyThingModelRequest build() {
            return new CopyThingModelRequest(this);
        }
    }
}

