/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateDataSourceItemRequest
extends Request {
    @Query
    @NameInMap(value="DataSourceId")
    @Validation(required=true, maximum=9.99999999999E11)
    private Long dataSourceId;
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="ScopeType")
    private String scopeType;
    @Query
    @NameInMap(value="Topic")
    @Validation(required=true)
    private String topic;

    private CreateDataSourceItemRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataSourceId = builder.dataSourceId;
        this.deviceName = builder.deviceName;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.scopeType = builder.scopeType;
        this.topic = builder.topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateDataSourceItemRequest create() {
        return CreateDataSourceItemRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getTopic() {
        return this.topic;
    }

    public static final class Builder
    extends Request.Builder<CreateDataSourceItemRequest, Builder> {
        private Long dataSourceId;
        private String deviceName;
        private String iotInstanceId;
        private String productKey;
        private String scopeType;
        private String topic;

        private Builder() {
        }

        private Builder(CreateDataSourceItemRequest request) {
            super((Request)request);
            this.dataSourceId = request.dataSourceId;
            this.deviceName = request.deviceName;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.scopeType = request.scopeType;
            this.topic = request.topic;
        }

        public Builder dataSourceId(Long dataSourceId) {
            this.putQueryParameter("DataSourceId", dataSourceId);
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder scopeType(String scopeType) {
            this.putQueryParameter("ScopeType", scopeType);
            this.scopeType = scopeType;
            return this;
        }

        public Builder topic(String topic) {
            this.putQueryParameter("Topic", topic);
            this.topic = topic;
            return this;
        }

        public CreateDataSourceItemRequest build() {
            return new CreateDataSourceItemRequest(this);
        }
    }
}

