/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateJobRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JobDocument")
    @Validation(required=true)
    private String jobDocument;
    @Query
    @NameInMap(value="JobFile")
    private Map<String, ?> jobFile;
    @Query
    @NameInMap(value="JobName")
    @Validation(required=true)
    private String jobName;
    @Query
    @NameInMap(value="RolloutConfig")
    private Map<String, ?> rolloutConfig;
    @Query
    @NameInMap(value="ScheduledTime")
    private Long scheduledTime;
    @Query
    @NameInMap(value="TargetConfig")
    @Validation(required=true)
    private Map<String, ?> targetConfig;
    @Query
    @NameInMap(value="TimeoutConfig")
    private Map<String, ?> timeoutConfig;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private CreateJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.iotInstanceId = builder.iotInstanceId;
        this.jobDocument = builder.jobDocument;
        this.jobFile = builder.jobFile;
        this.jobName = builder.jobName;
        this.rolloutConfig = builder.rolloutConfig;
        this.scheduledTime = builder.scheduledTime;
        this.targetConfig = builder.targetConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateJobRequest create() {
        return CreateJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJobDocument() {
        return this.jobDocument;
    }

    public Map<String, ?> getJobFile() {
        return this.jobFile;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Map<String, ?> getRolloutConfig() {
        return this.rolloutConfig;
    }

    public Long getScheduledTime() {
        return this.scheduledTime;
    }

    public Map<String, ?> getTargetConfig() {
        return this.targetConfig;
    }

    public Map<String, ?> getTimeoutConfig() {
        return this.timeoutConfig;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<CreateJobRequest, Builder> {
        private String description;
        private String iotInstanceId;
        private String jobDocument;
        private Map<String, ?> jobFile;
        private String jobName;
        private Map<String, ?> rolloutConfig;
        private Long scheduledTime;
        private Map<String, ?> targetConfig;
        private Map<String, ?> timeoutConfig;
        private String type;

        private Builder() {
        }

        private Builder(CreateJobRequest request) {
            super((Request)request);
            this.description = request.description;
            this.iotInstanceId = request.iotInstanceId;
            this.jobDocument = request.jobDocument;
            this.jobFile = request.jobFile;
            this.jobName = request.jobName;
            this.rolloutConfig = request.rolloutConfig;
            this.scheduledTime = request.scheduledTime;
            this.targetConfig = request.targetConfig;
            this.timeoutConfig = request.timeoutConfig;
            this.type = request.type;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder jobDocument(String jobDocument) {
            this.putQueryParameter("JobDocument", jobDocument);
            this.jobDocument = jobDocument;
            return this;
        }

        public Builder jobFile(Map<String, ?> jobFile) {
            String jobFileShrink = this.shrink(jobFile, "JobFile", "json");
            this.putQueryParameter("JobFile", jobFileShrink);
            this.jobFile = jobFile;
            return this;
        }

        public Builder jobName(String jobName) {
            this.putQueryParameter("JobName", jobName);
            this.jobName = jobName;
            return this;
        }

        public Builder rolloutConfig(Map<String, ?> rolloutConfig) {
            String rolloutConfigShrink = this.shrink(rolloutConfig, "RolloutConfig", "json");
            this.putQueryParameter("RolloutConfig", rolloutConfigShrink);
            this.rolloutConfig = rolloutConfig;
            return this;
        }

        public Builder scheduledTime(Long scheduledTime) {
            this.putQueryParameter("ScheduledTime", scheduledTime);
            this.scheduledTime = scheduledTime;
            return this;
        }

        public Builder targetConfig(Map<String, ?> targetConfig) {
            String targetConfigShrink = this.shrink(targetConfig, "TargetConfig", "json");
            this.putQueryParameter("TargetConfig", targetConfigShrink);
            this.targetConfig = targetConfig;
            return this;
        }

        public Builder timeoutConfig(Map<String, ?> timeoutConfig) {
            String timeoutConfigShrink = this.shrink(timeoutConfig, "TimeoutConfig", "json");
            this.putQueryParameter("TimeoutConfig", timeoutConfigShrink);
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }
    }
}

