/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateLoRaNodesTaskRequest
extends Request {
    @Query
    @NameInMap(value="DeviceInfo")
    @Validation(required=true)
    private List<DeviceInfo> deviceInfo;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private CreateLoRaNodesTaskRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceInfo = builder.deviceInfo;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateLoRaNodesTaskRequest create() {
        return CreateLoRaNodesTaskRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<DeviceInfo> getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static class DeviceInfo
    extends TeaModel {
        @NameInMap(value="DevEui")
        private String devEui;
        @NameInMap(value="PinCode")
        private String pinCode;

        private DeviceInfo(Builder builder) {
            this.devEui = builder.devEui;
            this.pinCode = builder.pinCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DeviceInfo create() {
            return DeviceInfo.builder().build();
        }

        public String getDevEui() {
            return this.devEui;
        }

        public String getPinCode() {
            return this.pinCode;
        }

        public static final class Builder {
            private String devEui;
            private String pinCode;

            public Builder devEui(String devEui) {
                this.devEui = devEui;
                return this;
            }

            public Builder pinCode(String pinCode) {
                this.pinCode = pinCode;
                return this;
            }

            public DeviceInfo build() {
                return new DeviceInfo(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateLoRaNodesTaskRequest, Builder> {
        private List<DeviceInfo> deviceInfo;
        private String iotInstanceId;
        private String productKey;

        private Builder() {
        }

        private Builder(CreateLoRaNodesTaskRequest request) {
            super((Request)request);
            this.deviceInfo = request.deviceInfo;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
        }

        public Builder deviceInfo(List<DeviceInfo> deviceInfo) {
            this.putQueryParameter("DeviceInfo", deviceInfo);
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public CreateLoRaNodesTaskRequest build() {
            return new CreateLoRaNodesTaskRequest(this);
        }
    }
}

